/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.config.impl.toml;

import codes.wasabi.xclaim.config.struct.Config;
import codes.wasabi.xclaim.shadow.toml.Toml;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TomlConfig
implements Config {
    protected final Toml table;
    protected final boolean valid;

    protected TomlConfig(@Nullable Toml table) {
        this.table = table;
        this.valid = table != null;
    }

    @NotNull
    protected final Toml raw() {
        if (this.valid) {
            return Objects.requireNonNull(this.table);
        }
        return new Toml();
    }

    @Nullable
    protected final Toml getTable(@NotNull String key) {
        if (this.valid) {
            return this.raw().getTable(key);
        }
        return null;
    }

    @Override
    @Nullable
    public Config sub(@NotNull String key) {
        return new TomlConfig(this.getTable(key));
    }

    @Override
    @Nullable
    public final String getString(@NotNull String key) {
        return this.getPrimitive(key, Toml::getString);
    }

    @Override
    @Nullable
    public final Boolean getBoolean(@NotNull String key) {
        return this.getPrimitive(key, Toml::getBoolean);
    }

    @Override
    @Nullable
    public final Integer getInt(@NotNull String key) {
        Long value = this.getLong(key);
        if (value == null) {
            return null;
        }
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException ignored) {
            return null;
        }
    }

    @Override
    @Nullable
    public final Long getLong(@NotNull String key) {
        return this.getPrimitive(key, Toml::getLong);
    }

    @Nullable
    private <T> T getPrimitive(@NotNull String key, @NotNull BiFunction<Toml, String, T> extractor) {
        if (this.valid) {
            try {
                return extractor.apply(this.raw(), key);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }
}

