/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.sub;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.ComponentLike;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.event.ClickEvent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextDecoration;
import codes.wasabi.xclaim.shadow.paperlib.PaperLib;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class InfoCommand
implements Command {
    @Override
    @NotNull
    public String getName() {
        return XClaim.lang.get("cmd-info-name");
    }

    @Override
    @NotNull
    public String getDescription() {
        return XClaim.lang.get("cmd-info-description");
    }

    @Override
    @NotNull
    public @NotNull Argument @NotNull [] getArguments() {
        return new Argument[0];
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int getNumRequiredArguments() {
        return 0;
    }

    @Override
    public boolean requiresPlayerExecutor() {
        return false;
    }

    @Override
    public void execute(@NotNull CommandSender sender, Object ... arguments) throws Exception {
        Audience audience = Platform.getAdventure().sender(sender);
        PluginDescriptionFile description = XClaim.instance.getDescription();
        String apiVersion = Platform.get().getApiVersion(description);
        if (apiVersion == null) {
            apiVersion = "1." + PaperLib.getMinecraftVersion() + "(?)";
        }
        int claimCount = 0;
        int chunkCount = 0;
        for (Claim c : Claim.getAll()) {
            ++claimCount;
            chunkCount += c.getChunks().size();
        }
        String pluralType = claimCount == 1 ? (chunkCount == 1 ? "not" : "chunk") : "both";
        Component claimText = XClaim.lang.getComponent("cmd-info-claims-" + pluralType + "-plural", claimCount, chunkCount);
        audience.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(((TextComponent)Component.text("XClaim").color(NamedTextColor.DARK_PURPLE)).decorate(TextDecoration.BOLD))).append((Component)Component.newline())).append(XClaim.lang.getComponent("cmd-info-author", ((TextComponent)Component.text("WasabiThumbs").color(NamedTextColor.GREEN)).clickEvent(ClickEvent.runCommand("Boy, I sure do love Wasabi and think he makes some pretty great plugins!"))))).append((Component)Component.newline())).append(XClaim.lang.getComponent("cmd-info-version", description.getVersion()))).append((Component)Component.newline())).append(XClaim.lang.getComponent("cmd-info-apiVersion", apiVersion))).append((Component)Component.newline())).append(claimText));
    }
}

