/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.sub;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.command.argument.type.ChoiceType;
import codes.wasabi.xclaim.command.argument.type.ComboType;
import codes.wasabi.xclaim.command.argument.type.RangeType;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.TextComponent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.event.ClickEvent;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.NamedTextColor;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.format.TextDecoration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class HelpCommand
implements Command {
    private final int commandsPerPage = 8;
    private final double d_commandsPerPage = 8.0;
    private Set<Command> commands = new LinkedHashSet<Command>();

    public void setCommands(@NotNull Collection<Command> commands) {
        this.commands = new LinkedHashSet<Command>(commands);
    }

    public void setCommands(Command ... commands) {
        this.commands = Arrays.stream(commands).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public boolean addCommand(@NotNull Command command) {
        return this.commands.add(command);
    }

    public boolean removeCommand(@NotNull Command command) {
        return this.commands.remove(command);
    }

    @Override
    @NotNull
    public String getName() {
        return XClaim.lang.get("cmd-help-name");
    }

    @Override
    @NotNull
    public String getDescription() {
        return XClaim.lang.get("cmd-help-description");
    }

    @Override
    @NotNull
    public @NotNull Argument @NotNull [] getArguments() {
        return new Argument[]{new Argument(new ComboType(new RangeType(1, (int)Math.floor((double)Math.max(this.commands.size() - 1, 0) / 8.0) + 1), new ChoiceType((String[])this.commands.stream().map(Command::getName).toArray(String[]::new))), XClaim.lang.get("cmd-help-arg-name"), XClaim.lang.get("cmd-help-arg-description"))};
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int getNumRequiredArguments() {
        return 0;
    }

    @Override
    public boolean requiresPlayerExecutor() {
        return false;
    }

    @Override
    public void execute(@NotNull CommandSender sender, Object ... arguments) throws Exception {
        Audience audience = Platform.getAdventure().sender(sender);
        int pageNum = 1;
        if (arguments.length > 0) {
            Object arg = arguments[0];
            if (arg instanceof Integer) {
                int num = arg != null ? (Integer)arg : pageNum;
                pageNum = num;
            } else if (arg instanceof String) {
                String str = (String)arg;
                Optional<Command> opt = this.commands.stream().filter(c -> c.getName().equalsIgnoreCase(str)).findFirst();
                if (!opt.isPresent()) {
                    audience.sendMessage(XClaim.lang.getComponent("cmd-help-err-404"));
                } else {
                    Command com = opt.get();
                    int numRequired = com.getNumRequiredArguments();
                    Argument[] args = com.getArguments();
                    StringBuilder argNames = new StringBuilder();
                    Component argDefs = Component.empty();
                    for (int i = 0; i < args.length; ++i) {
                        boolean required = i < numRequired;
                        Argument _a = args[i];
                        argNames.append(" ").append(required ? (char)'<' : '[').append(_a.name().toLowerCase(Locale.ROOT)).append(required ? (char)'>' : ']');
                        if (i > 0) {
                            argDefs = argDefs.append(Component.newline()).append(Component.newline());
                        }
                        argDefs = argDefs.append(Component.text(_a.name().toLowerCase(Locale.ROOT) + " ").color(NamedTextColor.LIGHT_PURPLE)).append(Component.text("(" + _a.type().getTypeName().toLowerCase(Locale.ROOT) + ")").color(NamedTextColor.DARK_PURPLE)).append(Component.newline()).append(Component.text(_a.description()).color(NamedTextColor.DARK_AQUA));
                    }
                    String exec = "/xclaim " + com.getName() + argNames;
                    Component component = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append(((TextComponent)((TextComponent)Component.text(exec).color(NamedTextColor.GOLD)).decorate(TextDecoration.UNDERLINED)).clickEvent(ClickEvent.suggestCommand(exec)))).append(Component.newline())).append(Component.text(com.getDescription()).color(NamedTextColor.YELLOW))).append(Component.newline());
                    component = args.length > 0 ? component.append(Component.newline()).append(argDefs) : component.append(XClaim.lang.getComponent("cmd-help-no-args"));
                    audience.sendMessage(component);
                }
                return;
            }
        }
        int maxPage = (int)Math.floor((double)Math.max(this.commands.size() - 1, 0) / 8.0) + 1;
        pageNum = Math.max(Math.min(pageNum, maxPage), 1);
        Component ret = Component.empty();
        Component head = Component.empty();
        head = head.append(Component.text("= ").color(NamedTextColor.GOLD));
        head = pageNum > 1 ? head.append(((TextComponent)Component.text("< ").color(NamedTextColor.YELLOW)).clickEvent(ClickEvent.runCommand("/xclaim help " + (pageNum - 1)))) : head.append(Component.text("  "));
        head = head.append(XClaim.lang.getComponent("cmd-help-page", pageNum));
        head = pageNum < maxPage ? head.append(((TextComponent)Component.text(" >").color(NamedTextColor.YELLOW)).clickEvent(ClickEvent.runCommand("/xclaim help " + (pageNum + 1)))) : head.append(Component.text("  "));
        head = head.append(Component.text(" =").color(NamedTextColor.GOLD));
        ret = ret.append(head);
        ret = ret.append(Component.newline());
        int fromIndex = (pageNum - 1) * 8;
        int toIndex = fromIndex + 8;
        int i = -1;
        for (Command cmd : this.commands) {
            if (++i < fromIndex) continue;
            if (i >= toIndex) break;
            ret = ret.append(Component.text(cmd.getName()).color(NamedTextColor.DARK_PURPLE));
            ret = ret.append(Component.text(" : ").color(NamedTextColor.DARK_AQUA));
            ret = ret.append(Component.text(cmd.getDescription())).color(NamedTextColor.LIGHT_PURPLE);
            ret = ret.append(Component.newline());
        }
        ret = ret.append(head);
        audience.sendMessage(ret);
    }
}

