/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.sub;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.command.argument.type.StandardTypes;
import codes.wasabi.xclaim.gui.ChunkEditor;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class ChunksCommand
implements Command {
    private final Argument[] args = new Argument[]{new Argument(StandardTypes.STRING, XClaim.lang.get("cmd-chunks-arg-name"), XClaim.lang.get("cmd-chunks-arg-description"))};

    @Override
    @NotNull
    public String getName() {
        return XClaim.lang.get("cmd-chunks-name");
    }

    @Override
    @NotNull
    public String getDescription() {
        return XClaim.lang.get("cmd-chunks-description");
    }

    @Override
    @NotNull
    public @NotNull Argument @NotNull [] getArguments() {
        return this.args;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int getNumRequiredArguments() {
        return 0;
    }

    @Override
    public boolean requiresPlayerExecutor() {
        return true;
    }

    @Override
    public void execute(@NotNull CommandSender sender, Object ... arguments) {
        Audience audience = Platform.getAdventure().sender(sender);
        Player ply = (Player)sender;
        if (ChunkEditor.getEditing(ply) != null) {
            audience.sendMessage(XClaim.lang.getComponent("cmd-chunks-err-state"));
        }
        Claim claim = null;
        if (arguments.length > 0) {
            try {
                String name = Objects.requireNonNull((String)arguments[0]);
                claim = Objects.requireNonNull(Claim.getByName(name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (claim == null) {
            Location loc = ply.getLocation();
            for (Claim c : Claim.getAll()) {
                if (!c.contains(loc)) continue;
                claim = c;
                break;
            }
            if (claim == null) {
                audience.sendMessage(XClaim.lang.getComponent("cmd-chunks-err-404"));
                return;
            }
        }
        if (!claim.hasPermission((OfflinePlayer)ply, Permission.MANAGE)) {
            audience.sendMessage(XClaim.lang.getComponent("cmd-chunks-err-perm"));
            return;
        }
        World w = claim.getWorld();
        if (w == null) {
            audience.sendMessage(XClaim.lang.getComponent("cmd-chunks-err-404"));
            return;
        }
        if (!XClaim.mainConfig.worlds().checkLists(w)) {
            audience.sendMessage(XClaim.lang.getComponent("cmd-chunks-err-disallowed"));
            return;
        }
        Platform.get().sendActionBar(ply, XClaim.lang.getComponent("cmd-chunks-success", claim.getName()));
        ply.playSound(ply.getLocation(), Platform.get().getMagicSound(), 1.0f, 1.0f);
        ChunkEditor.startEditing(ply, claim);
    }
}

