/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerType
extends Type<Player> {
    @Override
    @NotNull
    public Class<Player> getTypeClass() {
        return Player.class;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return XClaim.lang.get("arg-player-name");
    }

    @Override
    @NotNull
    public Collection<String> getSampleValues() {
        return Bukkit.getOnlinePlayers().stream().flatMap(ply -> Stream.of(ply.getName())).collect(Collectors.toList());
    }

    @Override
    @NotNull
    protected Player convert(@NotNull String string) throws NullPointerException {
        Player uncased = null;
        for (Player ply : Bukkit.getOnlinePlayers()) {
            String name = ply.getName();
            if (!name.equalsIgnoreCase(string)) continue;
            uncased = ply;
            if (!name.equals(string)) continue;
            return ply;
        }
        return Objects.requireNonNull(uncased);
    }
}

