/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComboType
extends Type<Object> {
    private final Type<?>[] types;
    private final String typeName;
    private final Set<String> samples;

    public ComboType(Type<?> ... types) throws IllegalArgumentException {
        if (types.length < 1) {
            throw new IllegalArgumentException("ComboType must be comprised of at least 1 type");
        }
        this.types = types;
        HashSet<String> names = new HashSet<String>();
        HashSet<String> sampleValues = new HashSet<String>();
        for (Type<?> type : types) {
            sampleValues.addAll(type.getSampleValues());
            names.add(type.getTypeName());
        }
        this.samples = Collections.unmodifiableSet(sampleValues);
        StringBuilder sb = new StringBuilder();
        if (names.size() > 5) {
            sb.append(XClaim.lang.get("arg-combo-many"));
        } else {
            String sep = XClaim.lang.get("arg-combo-separator");
            String or = XClaim.lang.get("arg-combo-or");
            int i = 0;
            for (String name : names) {
                if (i > 0) {
                    if (i < names.size() - 1) {
                        sb.append(sep);
                    } else {
                        sb.append(or);
                    }
                }
                sb.append(name);
                ++i;
            }
        }
        this.typeName = sb.toString();
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public Class<Object> getTypeClass() {
        return Object.class;
    }

    @Override
    @NotNull
    public Collection<String> getSampleValues() {
        return this.samples;
    }

    @Override
    @NotNull
    protected Object convert(@NotNull String string) throws IllegalArgumentException {
        for (Type<?> type : this.types) {
            try {
                return type.parse(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        throw new IllegalArgumentException("None of the types in this ComboType can successfully parse input \"" + string + "\"");
    }
}

