/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument.type;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ChoiceType
extends Type<String> {
    private final Collection<String> choices;

    public ChoiceType(@NotNull Collection<String> choices) {
        this.choices = choices;
    }

    public ChoiceType(String ... choices) {
        this(Arrays.asList(choices));
    }

    @Override
    @NotNull
    public Class<String> getTypeClass() {
        return String.class;
    }

    @Override
    @NotNull
    protected String convert(@NotNull String string) {
        return string;
    }

    @Override
    @NotNull
    public String getTypeName() {
        int len = this.choices.size();
        if (len == 0) {
            return XClaim.lang.get("arg-choice-nothing");
        }
        StringBuilder sb = new StringBuilder(XClaim.lang.get("arg-choice-root"));
        if (this.choices.size() > 5) {
            sb.append(XClaim.lang.get("arg-choice-many"));
        } else {
            String sep = XClaim.lang.get("arg-choice-separator");
            String or = XClaim.lang.get("arg-choice-or");
            Iterator<String> iter = this.choices.iterator();
            for (int i = 0; i < len; ++i) {
                sb.append(iter.next());
                if (i + 1 >= len) continue;
                if (i + 2 == len) {
                    sb.append(or);
                    continue;
                }
                sb.append(sep);
            }
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public Collection<String> getSampleValues() {
        return this.choices;
    }

    @Override
    protected boolean validate(@NotNull String value) {
        return this.choices.contains(value);
    }
}

