/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command.argument;

import codes.wasabi.xclaim.command.argument.type.Type;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Argument {
    private final Type<?> type;
    private final String name;
    private final String description;

    public Argument(@NotNull Type<?> type, @NotNull String name, @NotNull String description) {
        this.type = type;
        this.name = name;
        this.description = description;
    }

    @NotNull
    public final Type<?> type() {
        return this.type;
    }

    @NotNull
    public final String name() {
        return this.name;
    }

    @NotNull
    public final String description() {
        return this.description;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.description);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Argument && this.equals((Argument)obj)) {
            return true;
        }
        return super.equals(obj);
    }

    public boolean equals(Argument other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.description, other.description);
    }

    public String toString() {
        return "Argument[type=" + this.type + ",name=" + this.name + ",description=" + this.description + "]";
    }
}

