/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.command;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.command.Command;
import codes.wasabi.xclaim.command.argument.Argument;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.audience.Audience;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.util.IntLongConverter;
import com.cjburkey.claimchunk.ClaimChunk;
import com.cjburkey.claimchunk.chunk.ChunkPos;
import com.cjburkey.claimchunk.chunk.DataChunk;
import com.cjburkey.claimchunk.data.newdata.IClaimChunkDataHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class ImportCommand
implements Command {
    private static Object[] CHUNK_POS_GET_WORLD;
    private static Object[] CHUNK_POS_GET_X;
    private static Object[] CHUNK_POS_GET_Z;

    @Override
    @NotNull
    public String getName() {
        return XClaim.lang.get("cmd-import-name");
    }

    @Override
    @NotNull
    public String getDescription() {
        return XClaim.lang.get("cmd-import-description");
    }

    @Override
    @NotNull
    public @NotNull Argument @NotNull [] getArguments() {
        return new Argument[0];
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFL) int getNumRequiredArguments() {
        return 0;
    }

    @Override
    public boolean requiresPlayerExecutor() {
        return false;
    }

    @Override
    public void execute(@NotNull CommandSender sender, Object ... arguments) throws Exception {
        Audience audience = Platform.getAdventure().sender(sender);
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("ClaimChunk");
        if (plugin != null) {
            IClaimChunkDataHandler dataHandler;
            if (!plugin.isEnabled()) {
                audience.sendMessage(XClaim.lang.getComponent("cmd-import-err-disabled"));
                return;
            }
            ClaimChunk qual = (ClaimChunk)plugin;
            audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-handler"));
            try {
                Field field = qual.getClass().getDeclaredField("dataHandler");
                field.setAccessible(true);
                dataHandler = (IClaimChunkDataHandler)field.get(qual);
            }
            catch (Exception e) {
                audience.sendMessage(XClaim.lang.getComponent("cmd-import-err-reflect"));
                e.printStackTrace();
                return;
            }
            int importIndex = 1;
            for (World w : Bukkit.getWorlds()) {
                audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-world", w.getName()));
                UUIDPlane plane = new UUIDPlane();
                for (DataChunk chk : dataHandler.getClaimedChunks()) {
                    ChunkPos pos = chk.chunk;
                    if (!ImportCommand.chunkPosGetWorld(pos).equalsIgnoreCase(w.getName())) continue;
                    int x = ImportCommand.chunkPosGetX(pos);
                    int z = ImportCommand.chunkPosGetZ(pos);
                    audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-chunk", x, z));
                    UUID ownerUUID = chk.player;
                    plane.set(x, z, ownerUUID);
                }
                audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-fill"));
                Map<UUID, List<List<int[]>>> clumps = plane.pullClumps();
                for (Map.Entry<UUID, List<List<int[]>>> entry : clumps.entrySet()) {
                    Component name;
                    UUID uuid = entry.getKey();
                    OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
                    Player online = op.getPlayer();
                    if (online != null) {
                        name = Platform.get().playerDisplayName(online);
                    } else {
                        String n = op.getName();
                        if (n == null) {
                            n = uuid.toString();
                        }
                        name = Component.text(n);
                    }
                    audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-player", name));
                    for (List<int[]> cells : entry.getValue()) {
                        HashSet<Chunk> set = new HashSet<Chunk>();
                        for (int[] cell : cells) {
                            set.add(w.getChunkAt(cell[0], cell[1]));
                        }
                        Claim claim = new Claim("Imported Claim #" + importIndex, set, op);
                        claim.claim();
                        ++importIndex;
                    }
                    audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-success"));
                }
            }
            audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-disabling"));
            qual.disable();
            audience.sendMessage(XClaim.lang.getComponent("cmd-import-status-done"));
        } else {
            audience.sendMessage(XClaim.lang.getComponent("cmd-import-err-installed"));
        }
    }

    private static void findRecordMethod(Class<?> clazz, String name, Object[] data) {
        Method m;
        try {
            m = clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e1) {
            char[] chars = new char[name.length() + 3];
            CharBuffer.wrap(chars).put("get").put((char)(name.charAt(0) - 32)).put(name, 1, name.length());
            try {
                m = clazz.getMethod(new String(chars), new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                e2.addSuppressed(e1);
                data[1] = new AssertionError((Object)e2);
                return;
            }
        }
        data[0] = m;
    }

    private static Object unwrapRecordMethod(ChunkPos pos, Object[] data) {
        Object ret;
        if (data[0] == null) {
            throw (AssertionError)data[1];
        }
        Method m = (Method)data[0];
        try {
            ret = m.invoke((Object)pos, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
        return ret;
    }

    private static String chunkPosGetWorld(ChunkPos pos) {
        return (String)ImportCommand.unwrapRecordMethod(pos, CHUNK_POS_GET_WORLD);
    }

    private static int chunkPosGetX(ChunkPos pos) {
        return (Integer)ImportCommand.unwrapRecordMethod(pos, CHUNK_POS_GET_X);
    }

    private static int chunkPosGetZ(ChunkPos pos) {
        return (Integer)ImportCommand.unwrapRecordMethod(pos, CHUNK_POS_GET_Z);
    }

    static {
        Class<?> clazz = null;
        boolean found = false;
        try {
            clazz = Class.forName("com.cjburkey.claimchunk.chunk.ChunkPos");
            found = true;
        }
        catch (ClassNotFoundException e) {
            CHUNK_POS_GET_Z = new Object[]{null, new AssertionError((Object)e)};
            CHUNK_POS_GET_X = CHUNK_POS_GET_Z;
            CHUNK_POS_GET_WORLD = CHUNK_POS_GET_Z;
        }
        if (found) {
            CHUNK_POS_GET_WORLD = new Object[]{null, null};
            ImportCommand.findRecordMethod(clazz, "world", CHUNK_POS_GET_WORLD);
            CHUNK_POS_GET_X = new Object[]{null, null};
            ImportCommand.findRecordMethod(clazz, "x", CHUNK_POS_GET_X);
            CHUNK_POS_GET_Z = new Object[]{null, null};
            ImportCommand.findRecordMethod(clazz, "z", CHUNK_POS_GET_Z);
        }
    }

    private static class UUIDPlane {
        private final Map<Long, UUID> backingMap = new HashMap<Long, UUID>();

        private UUIDPlane() {
        }

        public void set(int x, int z, UUID uuid) {
            this.backingMap.put(IntLongConverter.intToLong(x, z), uuid);
        }

        public UUID get(int x, int z) {
            return this.backingMap.get(IntLongConverter.intToLong(x, z));
        }

        public List<int[]> pullClump(long curKey) {
            UUID uuid = this.backingMap.get(curKey);
            if (uuid == null) {
                return Collections.emptyList();
            }
            ArrayList<Long> queue = new ArrayList<Long>();
            ArrayList<int[]> ret = new ArrayList<int[]>();
            queue.add(curKey);
            while (queue.size() > 0) {
                int _z;
                long l = (Long)queue.remove(0);
                int[] coords = IntLongConverter.longToInt(l);
                int _x = coords[0];
                if (!Objects.equals(this.get(_x, _z = coords[1]), uuid)) continue;
                this.backingMap.remove(l);
                ret.add(new int[]{_x, _z});
                long leftKey = IntLongConverter.intToLong(_x - 1, _z);
                long rightKey = IntLongConverter.intToLong(_x + 1, _z);
                long upKey = IntLongConverter.intToLong(_x, _z - 1);
                long downKey = IntLongConverter.intToLong(_x, _z + 1);
                if (!queue.contains(leftKey)) {
                    queue.add(leftKey);
                }
                if (!queue.contains(rightKey)) {
                    queue.add(rightKey);
                }
                if (!queue.contains(upKey)) {
                    queue.add(upKey);
                }
                if (queue.contains(downKey)) continue;
                queue.add(downKey);
            }
            return ret;
        }

        public Map<UUID, List<List<int[]>>> pullClumps() {
            HashMap<UUID, List<List<int[]>>> clumps = new HashMap<UUID, List<List<int[]>>>();
            while (this.backingMap.size() > 0) {
                long start = (Long)this.backingMap.keySet().stream().findFirst().get();
                UUID uuid = this.backingMap.get(start);
                List<int[]> clump = this.pullClump(start);
                ArrayList<List<int[]>> cs = (ArrayList<List<int[]>>)clumps.get(uuid);
                if (cs == null) {
                    cs = new ArrayList<List<int[]>>();
                }
                cs.add(clump);
                clumps.put(uuid, cs);
            }
            return clumps;
        }
    }
}

