/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api.enums.permission.handler;

import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.enums.Permission;
import codes.wasabi.xclaim.api.enums.TrustLevel;
import codes.wasabi.xclaim.api.enums.permission.PermissionHandler;
import codes.wasabi.xclaim.platform.Platform;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.jetbrains.annotations.NotNull;

public class ExplosionHandler
extends PermissionHandler {
    public ExplosionHandler(@NotNull Claim claim) {
        super(claim);
    }

    @EventHandler
    public void onExplode(EntityExplodeEvent event) {
        Claim claim = this.getClaim();
        TrustLevel tl = claim.getPermission(Permission.EXPLODE);
        if (tl.equals((Object)TrustLevel.ALL)) {
            return;
        }
        Entity e = event.getEntity();
        if (!claim.contains(e.getLocation())) {
            return;
        }
        if (tl.equals((Object)TrustLevel.NONE)) {
            event.setCancelled(true);
            return;
        }
        if (e instanceof Creeper) {
            Creeper creeper = (Creeper)e;
            LivingEntity target = creeper.getTarget();
            boolean targetPrivileged = false;
            if (target != null && target instanceof Player) {
                Player pl = (Player)target;
                targetPrivileged = claim.hasPermission((OfflinePlayer)pl, Permission.EXPLODE);
            }
            if (!targetPrivileged) {
                event.setCancelled(true);
                World w = e.getWorld();
                Location loc = e.getLocation();
                Platform.get().createExplosion(w, loc, creeper.isPowered() ? 6.0f : 3.0f, false, false, (Entity)creeper);
                e.remove();
            }
        } else {
            TNTPrimed tnt;
            Entity source;
            if (e instanceof TNTPrimed && (source = (tnt = (TNTPrimed)e).getSource()) != null && source.isValid() && source instanceof Player) {
                Player pl = (Player)source;
                if (claim.hasPermission((OfflinePlayer)pl, Permission.EXPLODE)) {
                    return;
                }
                this.stdError(pl);
            }
            event.setCancelled(true);
        }
    }
}

