/*
 * Decompiled with CFR 0.152.
 */
package codes.wasabi.xclaim.api;

import codes.wasabi.xclaim.XClaim;
import codes.wasabi.xclaim.api.Claim;
import codes.wasabi.xclaim.api.XCPlayer;
import codes.wasabi.xclaim.platform.Platform;
import codes.wasabi.xclaim.shadow.kyori.adventure.text.Component;
import codes.wasabi.xclaim.util.ChunkReference;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MovementRoutine
implements Listener {
    private static MovementRoutine instance;
    private static boolean initialized;

    public static MovementRoutine getInstance() {
        return instance;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        instance = new MovementRoutine();
        Bukkit.getPluginManager().registerEvents((Listener)instance, (Plugin)XClaim.instance);
        initialized = true;
    }

    public static void cleanup() {
        if (!initialized) {
            return;
        }
        HandlerList.unregisterAll((Listener)instance);
        instance = null;
        initialized = false;
    }

    private MovementRoutine() {
    }

    private boolean chunkSemanticEquals(Object a, Object b) {
        int bType;
        int aType;
        int n = a instanceof Chunk ? 0 : (aType = a instanceof ChunkReference ? 1 : 2);
        int n2 = b instanceof Chunk ? 0 : (bType = b instanceof ChunkReference ? 1 : 2);
        if (aType > 1 || bType > 1) {
            return aType == bType;
        }
        ChunkReference ar = aType == 1 ? (ChunkReference)a : ChunkReference.ofChunk((Chunk)a);
        ChunkReference br = bType == 1 ? (ChunkReference)b : ChunkReference.ofChunk((Chunk)b);
        return Objects.equals(ar, br);
    }

    @EventHandler
    public void onMove(@NotNull PlayerMoveEvent event) {
        Chunk toChunk;
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        Chunk fromChunk = from.getChunk();
        if (this.chunkSemanticEquals(fromChunk, toChunk = to.getChunk())) {
            return;
        }
        Claim fromClaim = null;
        Claim toClaim = null;
        boolean fromSet = false;
        boolean toSet = false;
        for (Claim candidate : Claim.getAll()) {
            for (ChunkReference c : candidate.getChunks()) {
                if (this.chunkSemanticEquals(c, fromChunk)) {
                    fromClaim = candidate;
                    fromSet = true;
                    continue;
                }
                if (!this.chunkSemanticEquals(c, toChunk)) continue;
                toClaim = candidate;
                toSet = true;
            }
            if (!fromSet || !toSet) continue;
            break;
        }
        Player ply = event.getPlayer();
        if (toSet) {
            if (!toClaim.equals(fromClaim)) {
                Component name;
                XCPlayer claimOwner = toClaim.getOwner();
                Player online = claimOwner.getPlayer();
                if (online != null) {
                    name = Platform.get().playerDisplayName(online);
                } else {
                    String n = claimOwner.getName();
                    if (n == null) {
                        n = XClaim.lang.get("unknown");
                    }
                    name = Component.text(n);
                }
                Platform.get().sendActionBar(ply, XClaim.lang.getComponent("move-enter", name, Component.text(toClaim.getName())));
            }
        } else if (fromSet) {
            Platform.get().sendActionBar(ply, XClaim.lang.getComponent("move-exit", fromClaim.getName()));
        }
    }

    static {
        initialized = false;
    }
}

