/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.triggeredremoval.cleanermodules;

import java.util.HashMap;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigValueType;
import me.minebuilders.clearlag.modules.BroadcastHandler;
import me.minebuilders.clearlag.modules.ClearlagModule;
import me.minebuilders.clearlag.modules.TaskModule;

public class WarningJob
extends TaskModule {
    @ConfigValue(valueType=ConfigValueType.WARN_ARRAY)
    private HashMap<Integer, String[]> warnings;
    @ConfigValue
    private int executeJobTime;
    @AutoWire
    private BroadcastHandler broadcastHandler;
    private ClearlagModule wrappedJob;
    private int timer = 0;

    public WarningJob(ClearlagModule wrappedJob) {
        this.wrappedJob = wrappedJob;
    }

    public ClearlagModule getWrappedJob() {
        return this.wrappedJob;
    }

    public void setWrappedJob(ClearlagModule wrappedJob) {
        this.wrappedJob = wrappedJob;
    }

    @Override
    public void setEnabled() {
        super.setEnabled();
        this.timer = 0;
    }

    @Override
    public void run() {
        String[] broadcastWarning;
        if ((broadcastWarning = this.warnings.get(++this.timer)) != null) {
            for (String message : broadcastWarning) {
                this.broadcastHandler.broadcast(message.replace("+remaining", "" + (this.executeJobTime - this.timer)));
            }
        }
        if (this.timer >= this.executeJobTime) {
            super.setDisabled();
            this.wrappedJob.setEnabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() || this.wrappedJob.isEnabled();
    }

    @Override
    public void setDisabled() {
        if (super.isEnabled()) {
            super.setDisabled();
        } else {
            this.wrappedJob.setDisabled();
        }
    }
}

