/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.util.List;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.config.ConfigValueType;
import me.minebuilders.clearlag.modules.TaskModule;
import me.minebuilders.clearlag.tasks.TPSTask;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

@ConfigPath(path="tps-meter")
public class TPSCheckTask
extends TaskModule {
    @ConfigValue
    private List<String> commands;
    @ConfigValue
    private List<String> recoverCommands;
    @ConfigValue
    private double tpsTrigger;
    @ConfigValue
    private double tpsRecover;
    @ConfigValue(valueType=ConfigValueType.COLORED_STRING)
    private String triggerBroadcastMessage;
    @ConfigValue(valueType=ConfigValueType.COLORED_STRING)
    private String recoverBroadcastMessage;
    @ConfigValue
    private boolean broadcastEnabled;
    @AutoWire
    private TPSTask tpsTask;
    @AutoWire
    private ConfigHandler configHandler;
    private boolean isRecovered = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        double tps = this.tpsTask.getTPS();
        if (tps <= this.tpsTrigger && this.isRecovered) {
            if (this.broadcastEnabled) {
                Bukkit.broadcastMessage((String)this.triggerBroadcastMessage);
            }
            try {
                for (String s : this.commands) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s);
                }
            }
            catch (Exception e) {
                Util.warning("TPSCheckTask was unable to dispatch commands!");
            }
            finally {
                this.isRecovered = false;
            }
        } else if (tps >= this.tpsRecover && !this.isRecovered) {
            try {
                if (this.broadcastEnabled) {
                    Bukkit.broadcastMessage((String)this.recoverBroadcastMessage);
                }
                for (String s : this.recoverCommands) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s);
                }
            }
            catch (Exception e) {
                Util.warning("TPSCheckTask was unable to dispatch commands!");
            }
            finally {
                this.isRecovered = true;
            }
        }
    }

    @Override
    public int getInterval() {
        return this.configHandler.getConfig().getInt("tps-meter.interval") * 20;
    }

    @Override
    protected int startTask() {
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Clearlag.getInstance(), (Runnable)this, 420L, (long)this.getInterval());
    }
}

