/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.util.HashMap;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigModule;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigValueType;
import me.minebuilders.clearlag.managers.EntityManager;
import me.minebuilders.clearlag.modules.BroadcastHandler;
import me.minebuilders.clearlag.modules.TaskModule;
import me.minebuilders.clearlag.removetype.AutoClear;

@ConfigPath(path="auto-removal")
public class ClearTask
extends TaskModule {
    @ConfigModule
    private AutoClear autoClear = new AutoClear();
    @ConfigValue
    private int autoremovalInterval;
    @ConfigValue(valueType=ConfigValueType.COLORED_STRINGS)
    private String[] broadcastMessage;
    @ConfigValue(valueType=ConfigValueType.WARN_ARRAY)
    private HashMap<Integer, String[]> warnings;
    @ConfigValue(valueType=ConfigValueType.PRIMITIVE)
    private boolean broadcastRemoval;
    @AutoWire
    private EntityManager entityManager;
    @AutoWire
    private BroadcastHandler broadcastHandler;
    private int interval = 0;

    @Override
    public void run() {
        String[] broadcastWarning;
        if ((broadcastWarning = this.warnings.get(++this.interval)) != null) {
            this.broadcastHandler.broadcast(Util.cloneAndReplaceStringArr(broadcastWarning, "+remaining", "" + (this.autoremovalInterval - this.interval)));
        }
        if (this.interval >= this.autoremovalInterval) {
            if (this.broadcastRemoval) {
                this.broadcastHandler.broadcast(Util.cloneAndReplaceStringArr(this.broadcastMessage, "+RemoveAmount", String.valueOf(this.entityManager.removeEntities(this.autoClear))));
            }
            this.interval = 0;
        }
    }
}

