/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.statrenderers;

import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.adapters.VersionAdapter;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class StatRenderer
extends MapRenderer
implements Runnable {
    protected boolean pendingRefresh = true;
    protected int width = 128;
    protected int height = 128;
    protected final Player observer;
    protected final ItemStack mapItemStack;
    protected final MapView mapView;
    protected final int sampleTicks;
    private VersionAdapter versionAdapter;
    private final BukkitTask taskId;

    public StatRenderer(Player observer, int sampleTicks, ItemStack mapItemStack, VersionAdapter versionAdapter, MapView mapView) {
        this.observer = observer;
        this.mapView = mapView;
        this.mapItemStack = mapItemStack;
        this.versionAdapter = versionAdapter;
        this.sampleTicks = sampleTicks;
        this.taskId = Bukkit.getScheduler().runTaskTimer((Plugin)Clearlag.getInstance(), (Runnable)this, (long)sampleTicks, (long)sampleTicks);
    }

    public void cancel() {
        this.mapView.removeRenderer((MapRenderer)this);
        this.taskId.cancel();
    }

    public abstract void tick();

    public abstract void draw(MapView var1, MapCanvas var2, Player var3);

    @Override
    public void run() {
        if (!this.observer.isOnline() || this.observer.getItemInHand() == null || !this.versionAdapter.isMapItemStackEqual(this.observer.getItemInHand(), this.mapItemStack)) {
            this.cancel();
            return;
        }
        this.pendingRefresh = true;
        this.tick();
    }

    public void render(MapView mapView, MapCanvas mapCanvas, Player player) {
        MapCursorCollection mapCursorCollection = mapCanvas.getCursors();
        while (mapCursorCollection.size() > 0) {
            mapCursorCollection.removeCursor(mapCursorCollection.getCursor(0));
        }
        if (!this.pendingRefresh) {
            return;
        }
        for (int i = this.width; i >= 0; --i) {
            for (int j = this.height; j >= 0; --j) {
                mapCanvas.setPixel(i, j, (byte)0);
            }
        }
        this.draw(mapView, mapCanvas, player);
        this.pendingRefresh = false;
    }
}

