/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.statrenderers;

import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import me.minebuilders.clearlag.RAMUtil;
import me.minebuilders.clearlag.adapters.VersionAdapter;
import me.minebuilders.clearlag.statrenderers.StatRenderer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class ProcessRenderer
extends StatRenderer {
    private final int TICK_LENGTH = 50;
    private final int[] stateGroupTable = new int[5];
    private final byte[] stateColorTable = new byte[Thread.State.values().length];
    private final Thread watchingThread;
    private final LinkedList<StateColumn> threadStateColumns = new LinkedList();
    private final Lock lock = new ReentrantLock();
    private final Timer samplerTimer;

    public ProcessRenderer(Player observer, int sampleTicks, ItemStack mapItemStack, VersionAdapter versionAdapter, MapView mapView, Thread watchingThread) {
        super(observer, sampleTicks, mapItemStack, versionAdapter, mapView);
        this.watchingThread = watchingThread;
        this.defineState(Thread.State.RUNNABLE, 0, (byte)28);
        this.defineState(Thread.State.WAITING, 1, (byte)4);
        this.defineState(Thread.State.NEW, 2, (byte)16);
        this.defineState(Thread.State.BLOCKED, 3, (byte)16);
        this.defineState(Thread.State.TIMED_WAITING, 4, (byte)48);
        this.samplerTimer = new Timer("clearlag-thread-prober", true);
        this.samplerTimer.scheduleAtFixedRate((TimerTask)new SamplerThread(), 1L, 1L);
    }

    private void defineState(Thread.State state, int orderId, byte colorId) {
        this.stateGroupTable[state.ordinal()] = orderId;
        this.stateColorTable[orderId] = colorId;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.samplerTimer.cancel();
    }

    @Override
    public void tick() {
    }

    @Override
    public void draw(MapView mapView, MapCanvas mapCanvas, Player player) {
        int x = 0;
        int sleepTime = 0;
        int totalTime = 0;
        this.lock.lock();
        if (!this.threadStateColumns.isEmpty()) {
            totalTime = this.threadStateColumns.size() * 50;
            for (StateColumn stateColumn : this.threadStateColumns) {
                int drawPosition = this.height - 1;
                for (int i = 0; i < stateColumn.stateTable.length; ++i) {
                    int length = stateColumn.getStateCount(i);
                    if (length <= 0) continue;
                    if (i == 4) {
                        sleepTime += length;
                    }
                    byte color = this.stateColorTable[i];
                    for (int j = 0; j < length; ++j) {
                        mapCanvas.setPixel(x, drawPosition - j, color);
                    }
                    drawPosition -= length;
                }
                ++x;
            }
        }
        this.lock.unlock();
        int tickLineY = this.width - 51;
        for (int i = 0; i < this.width; ++i) {
            mapCanvas.setPixel(i, tickLineY, (byte)36);
        }
        if (totalTime != 0) {
            double threadUsage = 100.0 - (double)sleepTime / (double)totalTime * 100.0;
            mapCanvas.drawText(5, 5, (MapFont)MinecraftFont.Font, "\u00a744;Thread-Usage: \u00a716;" + (int)threadUsage + "%");
            double tickLength = (double)Math.round(threadUsage * 0.5 * 10.0) / 10.0;
            mapCanvas.drawText(5, 17, (MapFont)MinecraftFont.Font, "\u00a744;Tick-Length: \u00a716;" + tickLength + "ms");
            mapCanvas.drawText(6, 29, (MapFont)MinecraftFont.Font, "\u00a744;Memory: \u00a716;" + RAMUtil.getUsedMemory() + "MB");
        }
    }

    private class SamplerThread
    extends TimerTask {
        private StateColumn currentColumn = new StateColumn();

        private SamplerThread() {
        }

        @Override
        public void run() {
            if (this.currentColumn.length >= 50) {
                ProcessRenderer.this.lock.lock();
                try {
                    ProcessRenderer.this.threadStateColumns.addFirst(this.currentColumn);
                    if (ProcessRenderer.this.threadStateColumns.size() > ProcessRenderer.this.width) {
                        ProcessRenderer.this.threadStateColumns.removeLast();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    ProcessRenderer.this.lock.unlock();
                    this.currentColumn = new StateColumn();
                }
            }
            this.currentColumn.addStateStat(ProcessRenderer.this.stateGroupTable[ProcessRenderer.this.watchingThread.getState().ordinal()]);
        }
    }

    private static class StateColumn {
        private final int[] stateTable = new int[5];
        private int length;

        private StateColumn() {
        }

        public void addStateStat(int groupId) {
            int n = groupId;
            this.stateTable[n] = this.stateTable[n] + 1;
            ++this.length;
        }

        public int getStateCount(int groupId) {
            return this.stateTable[groupId];
        }

        public int getLength() {
            return this.length;
        }
    }
}

