/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.removetype;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigValueType;
import me.minebuilders.clearlag.modules.ClearModule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;

@ConfigPath(path="limit")
public class LimitClear
extends ClearModule {
    @ConfigValue
    private boolean item;
    @ConfigValue(valueType=ConfigValueType.MATERIAL_SET)
    private Set<Material> itemFilter;
    @ConfigValue
    private List<String> worldFilter = new ArrayList<String>();
    @ConfigValue
    private boolean itemframe;
    @ConfigValue
    private boolean fallingBlock;
    @ConfigValue
    private boolean boat;
    @ConfigValue
    private boolean experienceOrb;
    @ConfigValue
    private boolean painting;
    @ConfigValue
    private boolean projectile;
    @ConfigValue
    private boolean primedTnt;
    @ConfigValue
    private boolean minecart;

    @Override
    public boolean isRemovable(Entity e) {
        if (e instanceof Item) {
            return this.item && !this.itemFilter.contains(((Item)e).getItemStack().getType());
        }
        if (e instanceof ItemFrame) {
            return this.itemframe;
        }
        if (e instanceof FallingBlock) {
            return this.fallingBlock;
        }
        if (e instanceof Boat) {
            return e.isEmpty() && this.boat;
        }
        if (e instanceof ExperienceOrb) {
            return this.experienceOrb;
        }
        if (e instanceof Painting) {
            return this.painting;
        }
        if (e instanceof Projectile) {
            return this.projectile;
        }
        if (e instanceof TNTPrimed) {
            return this.primedTnt;
        }
        return e instanceof Minecart && e.isEmpty() && this.minecart;
    }

    @Override
    public boolean isWorldEnabled(World w) {
        return !this.worldFilter.contains(w.getName());
    }
}

