/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;

@ConfigPath(path="spawn-limiter")
public class MobLimitListener
extends EventModule
implements Runnable {
    @ConfigValue
    private int animals;
    @ConfigValue
    private int mobs;
    @ConfigValue
    private int interval;
    private int sched = -1;
    private boolean canAnimalspawn = true;
    private boolean canMobspawn = true;

    @Override
    public void run() {
        int animals = 0;
        int mobs = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Entity e : world.getEntities()) {
                if (e instanceof Animals || e instanceof Villager) {
                    ++animals;
                }
                if (!(e instanceof Creature)) continue;
                ++mobs;
            }
        }
        this.canAnimalspawn = animals < this.animals;
        this.canMobspawn = mobs < this.mobs;
    }

    @Override
    public void setEnabled() {
        super.setEnabled();
        this.sched = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Clearlag.getInstance(), (Runnable)this, (long)this.interval * 20L, (long)this.interval * 20L);
    }

    @Override
    public void setDisabled() {
        super.setDisabled();
        if (this.sched != -1) {
            Bukkit.getServer().getScheduler().cancelTask(this.sched);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onMobSpawn(CreatureSpawnEvent e) {
        LivingEntity en = e.getEntity();
        if (!this.canAnimalspawn && en instanceof Animals) {
            e.setCancelled(true);
        } else if (!this.canMobspawn && en instanceof Creature) {
            e.setCancelled(true);
        }
    }
}

