/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.language.messages;

import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.modules.BroadcastHandler;
import org.bukkit.command.CommandSender;

public class MessageBlock
implements Message {
    private final BroadcastHandler broadcastHandler;
    private final String[] rawMessage;
    private final String[] messageReplaceBits;

    public MessageBlock(BroadcastHandler broadcastHandler, String[] rawMessage, String ... messageReplaceBits) {
        this.broadcastHandler = broadcastHandler;
        this.rawMessage = rawMessage;
        this.messageReplaceBits = messageReplaceBits;
    }

    @Override
    public String getRawStringMessage() {
        return this.rawMessage[0];
    }

    @Override
    public String getStringMessage(Object ... obj) {
        StringBuilder sb = new StringBuilder();
        for (String message : this.rawMessage) {
            for (int i = 0; i < obj.length && i < this.messageReplaceBits.length; ++i) {
                message = message.replace(this.messageReplaceBits[i], obj[i].toString());
            }
            sb.append(sb.length() == 0 ? System.lineSeparator() + message : message);
        }
        return sb.toString();
    }

    @Override
    public void sendMessage(CommandSender sender, Object ... obj) {
        for (String message : this.rawMessage) {
            for (int i = 0; i < obj.length && i < this.messageReplaceBits.length; ++i) {
                message = message.replace(this.messageReplaceBits[i], obj[i].toString());
            }
            sender.sendMessage(message);
        }
    }

    @Override
    public void broadcastMessage(Object ... obj) {
        for (String message : this.rawMessage) {
            for (int i = 0; i < obj.length && i < this.messageReplaceBits.length; ++i) {
                message = message.replace(this.messageReplaceBits[i], obj[i].toString());
            }
            this.broadcastHandler.broadcast(this.getStringMessage(obj));
        }
    }
}

