/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.entities.attributes.EntityAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityHasMetaAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityHasNameAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityLifeLimitAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityMaterialAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityMountedAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityNameAttribute;
import me.minebuilders.clearlag.entities.attributes.EntityOnGroundAttribute;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class AttributeParser {
    public Result getAttributesFromString(EntityType t, StringTokenizer tk) {
        Result result = new Result();
        while (tk.hasMoreTokens()) {
            EntityAttribute attribute = null;
            String tok = tk.nextToken();
            boolean reversed = tok.startsWith("!");
            if (reversed) {
                tok = tok.substring(1);
            }
            if (tok.startsWith("name=\"") || tok.startsWith("hasMeta=\"")) {
                StringBuilder name = new StringBuilder();
                name.append(tok, 6, tok.endsWith("\"") ? tok.length() - 1 : tok.length());
                while (tk.hasMoreTokens()) {
                    tok = tk.nextToken();
                    if (tok.endsWith("\"")) {
                        name.append(" ").append(tok, 0, tok.length() - 1);
                        break;
                    }
                    name.append(" ").append(tok);
                }
                attribute = tok.startsWith("name=\"") ? new EntityNameAttribute(name.toString()) : new EntityHasMetaAttribute(name.toString());
            } else if (tok.startsWith("hasName")) {
                attribute = new EntityHasNameAttribute();
            } else if (tok.startsWith("liveTime=")) {
                attribute = new EntityLifeLimitAttribute(Integer.parseInt(tok.substring(9)));
            } else if (tok.startsWith("isMounted")) {
                attribute = new EntityMountedAttribute();
            } else if (tok.startsWith("onGround")) {
                attribute = new EntityOnGroundAttribute();
            } else if ((tok.startsWith("id=") || tok.startsWith("material=")) && t == EntityType.DROPPED_ITEM) {
                String input = tok.substring(3);
                Material mat = null;
                if (Util.isInteger(input)) {
                    int id = Integer.parseInt(input);
                    Util.warning("ID's are no longer usable in your Spigot version - Please change \"" + id + "\" into the item/block's name");
                } else {
                    mat = Material.getMaterial((String)input);
                    if (mat == null) {
                        mat = Material.matchMaterial((String)input);
                    }
                }
                attribute = new EntityMaterialAttribute(mat);
            }
            if (attribute != null) {
                attribute.setReversed(reversed);
                result.attributes.add(attribute);
                continue;
            }
            result.nonApplicables.add(tok);
        }
        return result;
    }

    public static class Result {
        private final ArrayList<EntityAttribute<Entity>> attributes = new ArrayList(2);
        private final List<String> nonApplicables = new ArrayList<String>(1);

        public ArrayList<EntityAttribute<Entity>> getAttributes() {
            return this.attributes;
        }

        public List<String> getNonApplicables() {
            return this.nonApplicables;
        }
    }
}

