/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config.configvalues;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.config.configvalues.ConfigData;
import me.minebuilders.clearlag.entities.AttributeParser;
import me.minebuilders.clearlag.entities.EntityMap;
import org.bukkit.entity.EntityType;

public class EntityLimitMapCV
implements ConfigData<EntityMap<Integer>> {
    @AutoWire
    private ConfigHandler configHandler;

    @Override
    public EntityMap<Integer> getValue(String path) {
        List entities = this.configHandler.getConfig().getStringList(path);
        EntityMap<Integer> entityMap = new EntityMap<Integer>();
        AttributeParser attributeParser = new AttributeParser();
        block6: for (String entityLine : entities) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(entityLine);
                String entityName = tokenizer.nextToken();
                EntityType entityType = Util.getEntityTypeFromString(entityName);
                if (entityType != null) {
                    try {
                        AttributeParser.Result result = attributeParser.getAttributesFromString(entityType, tokenizer);
                        Iterator<String> iter = result.getNonApplicables().iterator();
                        while (iter.hasNext()) {
                            String token = iter.next();
                            if (!token.startsWith("limit:")) continue;
                            iter.remove();
                            try {
                                for (String nonApplicable : result.getNonApplicables()) {
                                    Util.warning("Invalid entity attribute path=\"" + path + "\" token=" + nonApplicable + "\"");
                                }
                                int limit = Integer.parseInt(token.split(":", 2)[1]);
                                entityMap.set(entityType, result.getAttributes(), limit);
                                continue block6;
                            }
                            catch (Exception ignored) {
                                Util.warning("Invalid entity limit path=\"" + path + "\" token=" + token + "\"");
                            }
                        }
                    }
                    catch (Exception e) {
                        Util.warning("Failed to read entity path=\"" + path + "\" type=" + entityType.name() + "\" error=\"" + e + "\"");
                    }
                    continue;
                }
                Util.warning("Invalid entity type specified path=\"" + path + "\" value=" + entityName);
            }
            catch (Exception e) {
                Util.warning("Invalid line specified path=\"" + path + "\" line=" + entityLine);
            }
        }
        return entityMap;
    }
}

