/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config.configupdater.entries;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.minebuilders.clearlag.config.configupdater.entries.ConfigEntry;

public class ConfigListEntry
implements ConfigEntry {
    private String key;
    private List<Object> values = new ArrayList<Object>();

    public ConfigListEntry(String key, Object ... values) {
        this.key = key;
        this.values.addAll(Arrays.asList(values));
    }

    public void add(Object obj) {
        this.values.add(obj);
    }

    public void remove(Object obj) {
        this.values.remove(obj);
    }

    @Override
    public Object getValue() {
        return this.values;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void merge(ConfigEntry entry) {
        this.values = entry.getValue() instanceof List ? (List<Object>)entry.getValue() : new ArrayList<Object>(1);
    }

    @Override
    public void write(BufferedWriter writer, int tabs) throws IOException {
        StringBuilder tabLine = new StringBuilder();
        for (int i = 0; i < tabs; ++i) {
            tabLine.append("  ");
        }
        writer.write(tabLine.toString() + this.key + ":");
        if (this.values.isEmpty()) {
            writer.write(" []");
        } else {
            tabLine.append("  ");
            for (Object value : this.values) {
                writer.newLine();
                writer.write(tabLine.toString() + value.toString());
            }
        }
        writer.newLine();
    }
}

