/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.ConfigModule;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.configupdater.ConfigUpdater;
import me.minebuilders.clearlag.config.configvalues.ConfigData;
import me.minebuilders.clearlag.config.configvalues.PrimitiveCV;
import me.minebuilders.clearlag.modules.Module;
import me.minebuilders.clearlag.reflection.ReflectionUtil;
import me.minebuilders.clearlag.tasks.WarnTask;
import org.bukkit.configuration.Configuration;

public class ConfigHandler {
    private Configuration config;
    private final int version = 20;

    public Configuration getConfig() {
        return this.config;
    }

    public ConfigHandler() {
        Filter currentFilter = Clearlag.getInstance().getLogger().getFilter();
        final AtomicBoolean configLoadFailed = new AtomicBoolean(false);
        try {
            Clearlag.getInstance().getServer().getLogger().setFilter(new Filter(){

                @Override
                public boolean isLoggable(LogRecord record) {
                    if (record.getMessage().contains("ClearLag")) {
                        configLoadFailed.set(true);
                    }
                    return true;
                }
            });
            this.config = Clearlag.getInstance().getConfig();
            if (configLoadFailed.get()) {
                Util.warning("Clearlag failed to load to your config. Clearlag will now attempt to repair your config by force-updating it...");
                try {
                    this.updateConfig();
                    Clearlag.getInstance().reloadConfig();
                    this.config = Clearlag.getInstance().getConfig();
                }
                catch (Exception e) {
                    Util.warning("Clearlag failed to force-update your config. Using the default config - please repair your configuration using https://yaml-online-parser.appspot.com/");
                    throw e;
                }
            }
            Clearlag.getInstance().getServer().getLogger().setFilter(currentFilter);
        }
        catch (Exception e) {
            this.config = Clearlag.getInstance().getConfig();
        }
        if (!new File(Clearlag.getInstance().getDataFolder(), "config.yml").exists()) {
            Util.log("Config not found. Generating default config...");
            Clearlag.getInstance().saveDefaultConfig();
        } else if (!this.isConfigUpdated()) {
            boolean resetConfig = false;
            if (this.config.getBoolean("config-updater.force-update") && !this.isConfigUpdated()) {
                this.resetConfig("Old-Config.yml");
                resetConfig = true;
            } else if (!this.isConfigUpdated()) {
                try {
                    this.updateConfig();
                }
                catch (Exception e) {
                    Util.warning("Clearlag was unable to update your configuration and was forced to rename your current config and create a new one!");
                    Util.warning("Please run your config through a parser to check for errors: http://yaml-online-parser.appspot.com/");
                    this.resetConfig("Invalid-Config.yml");
                    resetConfig = true;
                    e.printStackTrace();
                }
            }
            WarnTask warnTask = new WarnTask(resetConfig);
            warnTask.setEnabled();
        }
        this.reloadConfig();
    }

    public boolean isConfigUpdated() {
        return this.config.isSet("config-version") && Util.isInteger(this.config.getString("config-version")) && this.config.getInt("config-version") >= 20;
    }

    public String fieldToConfigValue(Field field) {
        return this.javaToConfigValue(field.getName());
    }

    public String javaToConfigValue(String str) {
        StringBuilder sb = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (Character.isUpperCase(c)) {
                sb.append("-");
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void setModuleConfigValues() throws Exception {
        for (Module module : Clearlag.getModules()) {
            if (!module.isEnabled()) continue;
            this.setObjectConfigValues(module);
        }
    }

    public void setObjectConfigValues(Object object) throws Exception {
        String path = null;
        ConfigPath configPath = object.getClass().getAnnotation(ConfigPath.class);
        if (configPath != null) {
            path = configPath.path();
        }
        this.setObjectConfigValues(object, path);
    }

    public void setObjectConfigValues(Object object, String path) throws Exception {
        for (Class<?> clazz = object.getClass(); clazz != null && clazz != Object.class && clazz != Module.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                ConfigValue configValue = field.getAnnotation(ConfigValue.class);
                ConfigModule configModule = field.getAnnotation(ConfigModule.class);
                if (configValue != null) {
                    Object tp;
                    field.setAccessible(true);
                    ConfigData cd = configValue.valueType().getConfigData();
                    Object ob = cd.getValue(configValue.path().length() <= 1 ? path + "." + this.fieldToConfigValue(field) : configValue.path());
                    if (ob == null && (tp = field.get(object)) != null) {
                        ob = tp.getClass().newInstance();
                    }
                    field.set(object, cd instanceof PrimitiveCV ? ReflectionUtil.castPrimitedValues(field.getType(), ob) : ob);
                }
                if (configModule == null) continue;
                field.setAccessible(true);
                this.setObjectConfigValues(field.get(object));
            }
        }
    }

    public static boolean containsReloadableFields(Object ob) {
        for (Field field : ob.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(ConfigValue.class) && !field.isAnnotationPresent(ConfigModule.class)) continue;
            return true;
        }
        return false;
    }

    private void resetConfig(String renamedName) {
        this.renameCurrentConfig(renamedName);
        Clearlag.getInstance().saveDefaultConfig();
        Clearlag.getInstance().reloadConfig();
    }

    public void reloadConfig() {
        Clearlag.getInstance().reloadConfig();
        this.config = Clearlag.getInstance().getConfig();
    }

    private void renameCurrentConfig(String newName) {
        File newf = new File(Clearlag.getInstance().getDataFolder().getAbsolutePath(), "config.yml");
        File oldf = new File(Clearlag.getInstance().getDataFolder().getAbsolutePath(), newName);
        if (oldf.isFile()) {
            oldf.delete();
        }
        if (newf.isFile()) {
            newf.renameTo(new File(Clearlag.getInstance().getDataFolder().getAbsolutePath(), newName));
        }
    }

    private void updateConfig() throws Exception {
        Util.log("Updating config to v" + Clearlag.getInstance().getDescription().getVersion() + "...");
        File file = new File(Clearlag.getInstance().getDataFolder() + "/config.yml");
        ConfigUpdater configUpdater = new ConfigUpdater();
        configUpdater.addCarriedOverPath("custom-trigger-removal");
        configUpdater.addCarriedOverPath("item-spawn-age-setter");
        configUpdater.addNonMergableKey("config-version");
        configUpdater.setUpdatingToConfig(Clearlag.getInstance().getResource("config.yml"));
        configUpdater.setUpdatingFromConfig(new FileInputStream(Clearlag.getInstance().getDataFolder() + "/config.yml"));
        this.renameCurrentConfig("before-update-config.yml");
        configUpdater.updateConfig(file);
        Util.log("Successfully updated config to v" + Clearlag.getInstance().getDescription().getVersion() + "!");
    }
}

