/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.minebuilders.clearlag.Callback;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TickSamplerCmd
extends CommandModule {
    @LanguageValue(key="command.sampleticks.")
    private MessageTree lang;

    public TickSamplerCmd() {
        this.name = "sampleticks";
    }

    @Override
    protected void run(CommandSender sender, String[] args) {
        int sampleTickCycles = 1;
        if (args.length > 0 && Util.isInteger(args[0]) && (sampleTickCycles = Integer.parseInt(args[0])) <= 0) {
            sampleTickCycles = 1;
        }
        Thread serverThread = Thread.currentThread();
        Callback<Collection<Integer>> callback = args.length > 1 && args[1].equalsIgnoreCase("raw") ? sample -> {
            this.lang.sendMessage("rawheader", sender, new Object[0]);
            Message rawLineMessage = this.lang.getMessage("rawprint");
            for (Integer time : sample) {
                rawLineMessage.sendMessage(sender, Util.getChatColorByNumberLength(time, 40, 50).toString() + time);
            }
        } : samples -> {
            IntSummaryStatistics stats = samples.stream().mapToInt(x -> x).summaryStatistics();
            int spikes = 0;
            Iterator iterator = samples.iterator();
            while (iterator.hasNext()) {
                int sample = (Integer)iterator.next();
                if (sample <= 50) continue;
                ++spikes;
            }
            this.lang.sendMessage("print", sender, Util.getChatColorByNumberLength(stats.getMax(), 40, 50).toString() + stats.getMax(), Util.getChatColorByNumberLength(stats.getMin(), 40, 50).toString() + stats.getMin(), Util.getChatColorByNumberLength((int)Math.round(stats.getAverage()), 40, 50).toString() + Math.round(stats.getAverage()), Util.getChatColorByNumberLength(spikes, 1, 2).toString() + spikes);
        };
        new TimingThread(serverThread, callback, sampleTickCycles).start();
        this.lang.sendMessage("start", sender, serverThread.getName(), sampleTickCycles);
    }

    private static class TimingThread
    extends Thread {
        private final Thread watchingThread;
        private List<Integer> fullTickTimings;
        private Callback<Collection<Integer>> callback;
        private int sampleTickCycles;
        private AtomicInteger tick = new AtomicInteger();
        private final BukkitRunnable tickWatcher;

        public TimingThread(Thread watchingThread, Callback<Collection<Integer>> callback, int sampleTickCycles) {
            this.watchingThread = watchingThread;
            this.callback = callback;
            this.sampleTickCycles = ++sampleTickCycles;
            this.fullTickTimings = new ArrayList<Integer>(sampleTickCycles);
            this.tickWatcher = new BukkitRunnable(){

                public void run() {
                    tick.incrementAndGet();
                }
            };
            this.tickWatcher.runTaskTimer((Plugin)Clearlag.getInstance(), 0L, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.sampleTickCycles-- > 0) {
                    int startTick = this.tick.get();
                    long timestamp = System.currentTimeMillis();
                    while (this.watchingThread.getState() != Thread.State.TIMED_WAITING && this.tick.get() == startTick) {
                        Thread.sleep(1L);
                    }
                    this.fullTickTimings.add((int)(System.currentTimeMillis() - timestamp));
                    while (this.watchingThread.getState() == Thread.State.TIMED_WAITING && this.tick.get() == startTick) {
                        Thread.sleep(1L);
                    }
                }
                this.fullTickTimings.remove(0);
                Util.postToMainThread(() -> this.callback.call(this.fullTickTimings));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.tickWatcher.cancel();
            }
        }
    }
}

