/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import java.util.HashMap;
import java.util.Map;
import me.minebuilders.clearlag.Callback;
import me.minebuilders.clearlag.ChunkKey;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.MutableInt;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ProfileCmd
extends CommandModule {
    @LanguageValue(key="command.profile.")
    private MessageTree lang;
    @LanguageValue(key="command.profile.line")
    private Message lineMessage;
    private final ProfilerFactory[] profilerFactories = new ProfilerFactory[]{new ProfilerFactory("Redstone", RedstoneProfileSession.class), new ProfilerFactory("FlowingLiquid", FlowingLiquidProfileSession.class), new ProfilerFactory("BlockUpdate", BlockUpdateProfileSession.class), new ProfilerFactory("EntitySpawn", EntitySpawnProfileSession.class)};

    public ProfileCmd() {
        this.argLength = 2;
    }

    @Override
    protected void run(CommandSender sender, String[] args) throws WrongCommandArgumentException {
        if (!Util.isInteger(args[0])) {
            throw new WrongCommandArgumentException(this.lang.getMessage("invalidtime"), args[0]);
        }
        Callback<Map<ChunkKey, MutableInt>> callback = chunkKeyMutableIntMap -> {
            if (chunkKeyMutableIntMap.isEmpty()) {
                this.lang.sendMessage("nosamples", sender, new Object[0]);
                return;
            }
            int size = 10;
            Object[] sizes = new Integer[10];
            Object[] chunks = new ChunkKey[10];
            block0: for (Map.Entry entry : chunkKeyMutableIntMap.entrySet()) {
                int amount = ((MutableInt)entry.getValue()).getValue();
                for (int i = 0; i < 10; ++i) {
                    if (sizes[i] != null && sizes[i] >= amount) continue;
                    Util.shiftRight(chunks, i);
                    Util.shiftRight(sizes, i);
                    chunks[i] = (ChunkKey)entry.getKey();
                    sizes[i] = amount;
                    continue block0;
                }
            }
            this.lang.sendMessage("header", sender, new Object[0]);
            for (int i = 0; i < sizes.length; ++i) {
                ChunkKey c = chunks[i];
                this.lineMessage.sendMessage(sender, i + 1, c.getWorld().getName(), c.getX(), c.getZ(), sizes[i]);
            }
        };
        ProfileSession profileSession = null;
        for (ProfilerFactory factory : this.profilerFactories) {
            if (!factory.getId().equalsIgnoreCase(args[1])) continue;
            profileSession = factory.constructProfiler(callback);
            break;
        }
        if (profileSession == null) {
            StringBuilder sb = new StringBuilder();
            for (ProfilerFactory factory : this.profilerFactories) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(factory.getId());
            }
            throw new WrongCommandArgumentException(this.lang.getMessage("invalidprofiler"), args[1], sb.toString());
        }
        profileSession.runTaskLater((Plugin)Clearlag.getInstance(), Integer.parseInt(args[0]) * 20);
        Bukkit.getPluginManager().registerEvents((Listener)profileSession, (Plugin)Clearlag.getInstance());
        this.lang.sendMessage("started", sender, args[0]);
    }

    private static class EntitySpawnProfileSession
    extends ProfileSession {
        public EntitySpawnProfileSession(Callback<Map<ChunkKey, MutableInt>> callback) {
            super(callback);
        }

        @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
        public void onEntitySpawn(EntitySpawnEvent event) {
            this.incrementMap(event.getLocation().getChunk());
        }
    }

    private static class BlockUpdateProfileSession
    extends ProfileSession {
        public BlockUpdateProfileSession(Callback<Map<ChunkKey, MutableInt>> callback) {
            super(callback);
        }

        @EventHandler(ignoreCancelled=true)
        public void onBlockUpdate(BlockPhysicsEvent event) {
            this.incrementMap(event.getBlock().getChunk());
        }
    }

    private static class FlowingLiquidProfileSession
    extends ProfileSession {
        public FlowingLiquidProfileSession(Callback<Map<ChunkKey, MutableInt>> callback) {
            super(callback);
        }

        @EventHandler(ignoreCancelled=true)
        public void onFlow(BlockFromToEvent event) {
            this.incrementMap(event.getBlock().getChunk());
        }
    }

    private static class RedstoneProfileSession
    extends ProfileSession {
        public RedstoneProfileSession(Callback<Map<ChunkKey, MutableInt>> callback) {
            super(callback);
        }

        @EventHandler(ignoreCancelled=true)
        public void onRedstoneUpdate(BlockRedstoneEvent event) {
            this.incrementMap(event.getBlock().getChunk());
        }
    }

    private static abstract class ProfileSession
    extends BukkitRunnable
    implements Listener {
        final Map<ChunkKey, MutableInt> chunkMap = new HashMap<ChunkKey, MutableInt>();
        final Callback<Map<ChunkKey, MutableInt>> callback;

        public ProfileSession(Callback<Map<ChunkKey, MutableInt>> callback) {
            this.callback = callback;
        }

        public void run() {
            HandlerList.unregisterAll((Listener)this);
            this.callback.call(this.chunkMap);
        }

        protected void incrementMap(Chunk chunk) {
            ChunkKey key = new ChunkKey(chunk);
            MutableInt count = this.chunkMap.get(key);
            if (count == null) {
                count = new MutableInt(1);
                this.chunkMap.put(key, count);
            } else {
                count.increment();
            }
        }
    }

    private static class ProfilerFactory {
        private String id;
        private Class<? extends ProfileSession> sessionClass;

        public ProfilerFactory(String id, Class<? extends ProfileSession> sessionClass) {
            this.id = id;
            this.sessionClass = sessionClass;
        }

        public ProfileSession constructProfiler(Callback<Map<ChunkKey, MutableInt>> callback) {
            try {
                return (ProfileSession)((Object)this.sessionClass.getDeclaredConstructors()[0].newInstance(callback));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getId() {
            return this.id;
        }
    }
}

