/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.commands;

import java.util.IdentityHashMap;
import java.util.Map;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.CommandModule;
import org.bukkit.Chunk;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class CheckChunkCmd
extends CommandModule {
    @LanguageValue(key="command.checkchunk.line")
    private Message lineMessage;
    @LanguageValue(key="command.checkchunk.")
    private MessageTree lang;

    @Override
    protected void run(Player sender, String[] args) {
        Chunk c = sender.getLocation().getChunk();
        IdentityHashMap tileEntityCountMap = new IdentityHashMap(100);
        IdentityHashMap<EntityType, Integer> entityCountMap = new IdentityHashMap<EntityType, Integer>(100);
        for (BlockState blockState : c.getTileEntities()) {
            tileEntityCountMap.merge(blockState.getClass(), 1, Integer::sum);
        }
        for (BlockState blockState : c.getEntities()) {
            EntityType type = blockState.getType();
            entityCountMap.merge(type, 1, Integer::sum);
        }
        this.lang.sendMessage("header", (CommandSender)sender, new Object[0]);
        this.lang.sendMessage("tilelist", (CommandSender)sender, new Object[0]);
        for (Map.Entry entry : tileEntityCountMap.entrySet()) {
            this.lineMessage.sendMessage((CommandSender)sender, entry.getValue(), ((Class)entry.getKey()).getSimpleName().replace("Craft", ""));
        }
        this.lang.sendMessage("entitylist", (CommandSender)sender, new Object[0]);
        for (Map.Entry entry : entityCountMap.entrySet()) {
            this.lineMessage.sendMessage((CommandSender)sender, entry.getValue(), ((EntityType)entry.getKey()).name().toLowerCase().replace("_", " "));
        }
        this.lang.sendMessage("footer", (CommandSender)sender, new Object[0]);
    }
}

