/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.adapters;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.adapters.VersionAdapter;
import me.minebuilders.clearlag.reflection.ReflectionUtil;
import org.bukkit.Material;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapView;

public class LegacyVersionAdapter
implements VersionAdapter {
    private static final Field itemField = ReflectionUtil.getField(ReflectionUtil.getClass("org.bukkit.craftbukkit." + Util.getRawBukkitVersion() + ".entity", "CraftItem"), "item");
    private static final Field mcItemSetAge = ReflectionUtil.getField(ReflectionUtil.getClass("net.minecraft.server." + Util.getRawBukkitVersion(), "EntityItem"), "age");

    @Override
    public boolean isCompatible() {
        return Material.getMaterial((String)"MAP") != null && mcItemSetAge != null && itemField != null;
    }

    @Override
    public ItemStack createMapItemStack(MapView mapView) {
        ItemStack mapItemStack = new ItemStack(Material.MAP, 1);
        try {
            Method method = MapView.class.getDeclaredMethod("getId", new Class[0]);
            method.setAccessible(true);
            short id = (Short)method.invoke((Object)mapView, new Object[0]);
            mapItemStack.setDurability(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapItemStack;
    }

    @Override
    public boolean isMapItemStackEqual(ItemStack itemStack, ItemStack itemStack2) {
        return itemStack.getDurability() == itemStack2.getDurability();
    }

    @Override
    public void setItemEntityAge(Item item, int age) {
        try {
            item.setTicksLived(age);
            Object nmsEntity = itemField.get(item);
            mcItemSetAge.set(nmsEntity, age);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

