/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Util;
import org.bukkit.Bukkit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class BukkitUpdater
implements Runnable {
    private static final String HOST = "https://api.curseforge.com/servermods/files?projectIds=37824";
    private String newversion;
    private String download;
    private File file;

    public BukkitUpdater(File file) {
        this.file = file;
        new Thread(this).start();
    }

    private int versionToInt(String s) {
        return Integer.parseInt(s.replaceAll("[^\\d.]", "").replace(".", "").trim());
    }

    private boolean updateAvailable() throws Exception {
        String ver;
        Util.log("Checking for updates compatible with your bukkit version [" + Util.getBukkitVersion() + "]...");
        HttpURLConnection conn = this.createConnection(HOST, 6000);
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String response = reader.readLine();
        String bukkitversion = Util.getBukkitVersion();
        JSONArray array = (JSONArray)JSONValue.parse((String)response);
        JSONObject line = null;
        boolean isLegacy = bukkitversion.contains("1.7");
        for (int i = array.size() - 1; i > 17 && !(ver = (String)(line = (JSONObject)array.get(i)).get((Object)"gameVersion")).contains(bukkitversion) && (isLegacy || ver.contains("1.7")); --i) {
        }
        this.newversion = line.get((Object)"name").toString();
        this.download = (String)line.get((Object)"downloadUrl");
        return this.versionToInt(Clearlag.getInstance().getDescription().getVersion()) < this.versionToInt(this.newversion);
    }

    private HttpURLConnection createConnection(String url, int timeout) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(timeout);
        conn.setInstanceFollowRedirects(true);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.82 Safari/537.36");
        return conn;
    }

    @Override
    public void run() {
        block32: {
            try {
                if (this.updateAvailable()) {
                    HttpURLConnection conn;
                    int response;
                    Util.log("Clearlag version " + this.newversion + " update available! Downloading...");
                    if (!Bukkit.getUpdateFolderFile().exists()) {
                        Bukkit.getUpdateFolderFile().mkdir();
                    }
                    if ((response = (conn = this.createConnection(this.download, 15000)).getResponseCode()) == 301 || response == 302) {
                        this.download = conn.getHeaderField("Location");
                        conn = this.createConnection(this.download, 15000);
                    }
                    try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                         FileOutputStream fout = new FileOutputStream(Bukkit.getUpdateFolderFile().getAbsolutePath() + "/" + this.file.getName());){
                        int count;
                        byte[] data = new byte[1024];
                        while ((count = in.read(data, 0, 1024)) != -1) {
                            fout.write(data, 0, count);
                        }
                        Util.log("Updating finished! Restart your server for files to take effect");
                        break block32;
                    }
                    catch (Exception e) {
                        Util.log("Failed to download the latest update!");
                    }
                    break block32;
                }
                Util.log("No updates found!");
            }
            catch (Exception e) {
                Util.warning("Clearlag failed to check for updates - bukkit may be down");
                e.printStackTrace();
            }
        }
    }
}

