/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.v1_20_R3;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.impl.v1_20_R3.PaperweightAdapter;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.world.block.BlockState;
import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.enginehub.linbus.tree.LinCompoundTag;

public class PaperweightWorldNativeAccess
implements WorldNativeAccess<LevelChunk, net.minecraft.world.level.block.state.BlockState, BlockPos> {
    private static final int UPDATE = 1;
    private static final int NOTIFY = 2;
    private final PaperweightAdapter adapter;
    private final WeakReference<ServerLevel> world;
    private SideEffectSet sideEffectSet;

    public PaperweightWorldNativeAccess(PaperweightAdapter adapter, WeakReference<ServerLevel> world) {
        this.adapter = adapter;
        this.world = world;
    }

    private ServerLevel getWorld() {
        return Objects.requireNonNull((ServerLevel)this.world.get(), "The reference to the world was lost");
    }

    @Override
    public void setCurrentSideEffectSet(SideEffectSet sideEffectSet) {
        this.sideEffectSet = sideEffectSet;
    }

    @Override
    public LevelChunk getChunk(int x, int z) {
        return this.getWorld().getChunk(x, z);
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState toNative(BlockState state) {
        int stateId = BlockStateIdAccess.getBlockStateId(state);
        return BlockStateIdAccess.isValidInternalId(stateId) ? Block.stateById((int)stateId) : ((CraftBlockData)BukkitAdapter.adapt(state)).getState();
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getBlockState(LevelChunk chunk, BlockPos position) {
        return chunk.getBlockState(position);
    }

    @Override
    @Nullable
    public net.minecraft.world.level.block.state.BlockState setBlockState(LevelChunk chunk, BlockPos position, net.minecraft.world.level.block.state.BlockState state) {
        return chunk.setBlockState(position, state, false, this.sideEffectSet.shouldApply(SideEffect.UPDATE));
    }

    @Override
    public net.minecraft.world.level.block.state.BlockState getValidBlockForPosition(net.minecraft.world.level.block.state.BlockState block, BlockPos position) {
        return Block.updateFromNeighbourShapes((net.minecraft.world.level.block.state.BlockState)block, (LevelAccessor)this.getWorld(), (BlockPos)position);
    }

    @Override
    public BlockPos getPosition(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public void updateLightingForBlock(BlockPos position) {
        this.getWorld().l().getLightEngine().checkBlock(position);
    }

    @Override
    public boolean updateTileEntity(BlockPos position, LinCompoundTag tag) {
        BlockEntity tileEntity = this.getWorld().getBlockEntity(position);
        if (tileEntity == null) {
            return false;
        }
        Tag nativeTag = this.adapter.fromNative(tag);
        PaperweightAdapter.readTagIntoTileEntity((CompoundTag)nativeTag, tileEntity);
        return true;
    }

    @Override
    public void notifyBlockUpdate(LevelChunk chunk, BlockPos position, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        if (chunk.getSections()[this.getWorld().e(position.getY())] != null) {
            this.getWorld().sendBlockUpdated(position, oldState, newState, 3);
        }
    }

    @Override
    public boolean isChunkTicking(LevelChunk chunk) {
        return chunk.D().isOrAfter(FullChunkStatus.BLOCK_TICKING);
    }

    @Override
    public void markBlockChanged(LevelChunk chunk, BlockPos position) {
        if (chunk.getSections()[this.getWorld().e(position.getY())] != null) {
            this.getWorld().l().blockChanged(position);
        }
    }

    @Override
    public void notifyNeighbors(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        ServerLevel world = this.getWorld();
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            world.updateNeighborsAt(pos, oldState.getBlock());
        } else {
            Block block = oldState.getBlock();
            this.fireNeighborChanged(pos, world, block, pos.south());
            this.fireNeighborChanged(pos, world, block, pos.west());
            this.fireNeighborChanged(pos, world, block, pos.above());
            this.fireNeighborChanged(pos, world, block, pos.c());
            this.fireNeighborChanged(pos, world, block, pos.below());
            this.fireNeighborChanged(pos, world, block, pos.north());
        }
        if (newState.liquid()) {
            world.updateNeighbourForOutputSignal(pos, newState.getBlock());
        }
    }

    @Override
    public void updateBlock(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        ServerLevel world = this.getWorld();
        newState.onPlace((Level)world, pos, oldState, false);
    }

    private void fireNeighborChanged(BlockPos pos, ServerLevel world, Block block, BlockPos neighborPos) {
        world.getBlockState(neighborPos).a((Level)world, neighborPos, block, pos, false);
    }

    @Override
    public void updateNeighbors(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState, int recursionLimit) {
        ServerLevel world = this.getWorld();
        oldState.updateIndirectNeighbourShapes((LevelAccessor)world, pos, 2, recursionLimit);
        if (this.sideEffectSet.shouldApply(SideEffect.EVENTS)) {
            CraftWorld craftWorld = world.getWorld();
            BlockPhysicsEvent event = new BlockPhysicsEvent(craftWorld.getBlockAt(pos.getX(), pos.getY(), pos.getZ()), (BlockData)CraftBlockData.fromData((net.minecraft.world.level.block.state.BlockState)newState));
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        newState.updateNeighbourShapes((LevelAccessor)world, pos, 2, recursionLimit);
        newState.updateIndirectNeighbourShapes((LevelAccessor)world, pos, 2, recursionLimit);
    }

    @Override
    public void onBlockStateChange(BlockPos pos, net.minecraft.world.level.block.state.BlockState oldState, net.minecraft.world.level.block.state.BlockState newState) {
        this.getWorld().onBlockStateChange(pos, oldState, newState);
    }
}

