/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.EssentialsLogger;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.metrics.MetricsWrapper;
import com.earth2me.essentials.spawn.EssentialsSpawnPlayerListener;
import com.earth2me.essentials.spawn.IEssentialsSpawn;
import com.earth2me.essentials.spawn.SpawnStorage;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsSpawn
extends JavaPlugin
implements IEssentialsSpawn {
    private transient IEssentials ess;
    private transient SpawnStorage spawns;
    private transient MetricsWrapper metrics = null;

    public void onEnable() {
        EventPriority joinPriority;
        EssentialsLogger.updatePluginLogger((Plugin)this);
        PluginManager pluginManager = this.getServer().getPluginManager();
        this.ess = (IEssentials)pluginManager.getPlugin("Essentials");
        if (!this.getDescription().getVersion().equals(this.ess.getDescription().getVersion())) {
            this.getLogger().log(Level.WARNING, I18n.tl((String)"versionMismatchAll", (Object[])new Object[0]));
        }
        if (!this.ess.isEnabled()) {
            this.setEnabled(false);
            return;
        }
        this.spawns = new SpawnStorage(this.ess);
        this.ess.addReloadListener((IConf)this.spawns);
        EssentialsSpawnPlayerListener playerListener = new EssentialsSpawnPlayerListener(this.ess, this.spawns);
        EventPriority respawnPriority = this.ess.getSettings().getRespawnPriority();
        if (respawnPriority != null) {
            pluginManager.registerEvent(PlayerRespawnEvent.class, (Listener)playerListener, respawnPriority, (ll, event) -> ((EssentialsSpawnPlayerListener)ll).onPlayerRespawn((PlayerRespawnEvent)event), (Plugin)this);
        }
        if ((joinPriority = this.ess.getSettings().getSpawnJoinPriority()) != null) {
            pluginManager.registerEvent(PlayerJoinEvent.class, (Listener)playerListener, joinPriority, (ll, event) -> ((EssentialsSpawnPlayerListener)ll).onPlayerJoin((PlayerJoinEvent)event), (Plugin)this);
        }
        if (this.metrics == null) {
            this.metrics = new MetricsWrapper((JavaPlugin)this, 3817, true);
        }
    }

    public static Logger getWrappedLogger() {
        try {
            return EssentialsLogger.getLoggerProvider((String)"EssentialsSpawn");
        }
        catch (Throwable ignored) {
            return Logger.getLogger("EssentialsSpawn");
        }
    }

    public void onDisable() {
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        this.metrics.markCommand(command.getName(), true);
        return this.ess.onCommandEssentials(sender, command, commandLabel, args, EssentialsSpawn.class.getClassLoader(), "com.earth2me.essentials.spawn.Command", "essentials.", (IEssentialsModule)this.spawns);
    }

    @Override
    public void setSpawn(Location loc, String group) {
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        this.spawns.setSpawn(loc, group);
    }

    @Override
    public Location getSpawn(String group) {
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        return this.spawns.getSpawn(group);
    }
}

