/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.spawn;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.spawn.SpawnStorage;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.ess3.api.IUser;
import net.essentialsx.api.v2.events.UserTeleportSpawnEvent;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandspawn
extends EssentialsCommand {
    public Commandspawn() {
        super("spawn");
    }

    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        Trade charge = new Trade(this.getName(), this.ess);
        charge.isAffordableFor((IUser)user);
        if (args.length > 0 && user.isAuthorized("essentials.spawn.others")) {
            User otherUser = this.getPlayer(server, user, args, 0);
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            future.thenAccept(success -> {
                if (success.booleanValue() && !otherUser.equals((Object)user)) {
                    otherUser.sendMessage(I18n.tl((String)"teleportAtoB", (Object[])new Object[]{user.getDisplayName(), "spawn"}));
                }
            });
            this.respawn(user.getSource(), user, otherUser, charge, commandLabel, future);
        } else {
            this.respawn(user.getSource(), user, user, charge, commandLabel, new CompletableFuture<Boolean>());
        }
        throw new NoChargeException();
    }

    protected void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, args, 0, true, false);
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.respawn(sender, null, user, null, commandLabel, future);
        future.thenAccept(success -> {
            if (success.booleanValue()) {
                user.sendMessage(I18n.tl((String)"teleportAtoB", (Object[])new Object[]{Console.DISPLAY_NAME, "spawn"}));
            }
        });
    }

    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1 && sender.isAuthorized("essentials.spawn.others", (IEssentials)this.ess)) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }

    private void respawn(CommandSource sender, User teleportOwner, User teleportee, Trade charge, String commandLabel, CompletableFuture<Boolean> future) throws Exception {
        Location spawn = ((SpawnStorage)this.module).getSpawn(teleportee.getGroup());
        if (spawn == null) {
            return;
        }
        sender.sendMessage(I18n.tl((String)"teleporting", (Object[])new Object[]{spawn.getWorld().getName(), spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()}));
        future.exceptionally(e -> {
            this.showError(sender.getSender(), (Throwable)e, commandLabel);
            return false;
        });
        UserTeleportSpawnEvent spawnEvent = new UserTeleportSpawnEvent((IUser)teleportee, (IUser)teleportOwner, teleportee.getGroup(), spawn);
        this.ess.getServer().getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            return;
        }
        if (teleportOwner == null) {
            teleportee.getAsyncTeleport().now(spawn, false, PlayerTeleportEvent.TeleportCause.COMMAND, future);
            return;
        }
        teleportOwner.getAsyncTeleport().teleportPlayer((IUser)teleportee, spawn, charge, PlayerTeleportEvent.TeleportCause.COMMAND, future);
    }
}

