/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.triggeredremoval.triggers;

import java.util.Set;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigValueType;
import me.minebuilders.clearlag.entities.EntityTable;
import me.minebuilders.clearlag.triggeredremoval.CleanerHandler;
import me.minebuilders.clearlag.triggeredremoval.triggers.CleanerTrigger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class EntityLimitTrigger
extends CleanerTrigger {
    @ConfigValue(valueType=ConfigValueType.ENTITY_TYPE_TABLE)
    private EntityTable entityLimits;
    @ConfigValue
    private int limit;
    @ConfigValue(valueType=ConfigValueType.STRING_SET)
    private Set<String> worldFilter;

    public EntityLimitTrigger(CleanerHandler cleanerHandler) {
        super(cleanerHandler);
    }

    @Override
    public boolean shouldTrigger() {
        return this.countEntities() >= this.limit;
    }

    @Override
    public boolean isRecovered() {
        return super.isRecovered() && !this.shouldTrigger();
    }

    private int countEntities() {
        int entities = 0;
        for (World world : Bukkit.getWorlds()) {
            if (this.worldFilter.contains(world.getName())) continue;
            for (Entity entity : world.getEntities()) {
                if (!this.entityLimits.containsEntity(entity)) continue;
                ++entities;
            }
        }
        return entities;
    }
}

