/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.triggeredremoval.triggers;

import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.triggeredremoval.CleanerHandler;
import me.minebuilders.clearlag.triggeredremoval.triggers.Trigger;

public abstract class CleanerTrigger
implements Trigger {
    private boolean triggered = false;
    @ConfigValue
    private int runInterval;
    protected CleanerHandler cleanerHandler;

    public CleanerTrigger(CleanerHandler cleanerHandler) {
        this.cleanerHandler = cleanerHandler;
    }

    @Override
    public boolean runTrigger() {
        if (!this.triggered) {
            if (this.shouldTrigger()) {
                this.triggered = true;
                this.cleanerHandler.startJobs();
            }
        } else if (this.isRecovered()) {
            this.triggered = false;
        }
        return this.triggered;
    }

    public abstract boolean shouldTrigger();

    public boolean isRecovered() {
        return this.cleanerHandler.areJobsComplete();
    }

    public CleanerHandler getCleanerHandler() {
        return this.cleanerHandler;
    }

    @Override
    public int getCheckFrequency() {
        return this.runInterval;
    }
}

