/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.lang.reflect.Field;
import java.util.Arrays;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.events.TPSUpdateEvent;
import me.minebuilders.clearlag.modules.TaskModule;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

@ConfigPath(path="settings")
public class TPSTask
extends TaskModule {
    private double[] tpsHistory = new double[10];
    private int index = 0;
    private TPSCalculator tpsCalculator;
    @AutoWire
    private ConfigHandler configHandler;
    private int elapsedTicks = 0;

    @Override
    public void setEnabled() {
        super.setEnabled();
        Arrays.fill(this.tpsHistory, 20.0);
    }

    @Override
    protected int startTask() {
        this.elapsedTicks = 0;
        if (this.configHandler.getConfig().getBoolean("settings.use-internal-tps")) {
            try {
                this.tpsCalculator = new InternalTPSYoinker();
            }
            catch (Exception e) {
                Util.warning("Clearlag failed to use the internal TPS tracker during initialization. Reverted to estimation... (" + e.getMessage() + ")");
                this.tpsCalculator = new EstimatedTPSCalculator();
            }
        } else {
            this.tpsCalculator = new EstimatedTPSCalculator();
        }
        return Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Clearlag.getInstance(), (Runnable)this, 120L, (long)this.getInterval());
    }

    public double getTPS() {
        double tpsSum = 0.0;
        for (double d : this.tpsHistory) {
            tpsSum += d;
        }
        return (double)Math.round(tpsSum / 10.0 * 100.0) / 100.0;
    }

    public String getStringTPS() {
        return this.getColor() + String.valueOf(this.getTPS());
    }

    public ChatColor getColor() {
        double tps = this.getTPS();
        if (tps > 17.0) {
            return ChatColor.GREEN;
        }
        if (tps > 13.0) {
            return ChatColor.GOLD;
        }
        return ChatColor.RED;
    }

    @Override
    public void run() {
        double tps;
        this.tpsCalculator.tick();
        if (this.elapsedTicks % 20 == 0 && (tps = this.tpsCalculator.calculateCurrentAverageTPS()) > 0.0 && tps <= 21.0) {
            this.tpsHistory[this.index++] = tps;
            if (this.index >= this.tpsHistory.length) {
                this.index = 0;
                Bukkit.getPluginManager().callEvent((Event)new TPSUpdateEvent(this.getTPS()));
            }
        }
    }

    @Override
    public int getInterval() {
        return 1;
    }

    private class InternalTPSYoinker
    implements TPSCalculator {
        private final Field recentTpsField;
        private final Object minecraftServerInstance;
        private double tps = 20.0;

        public InternalTPSYoinker() throws Exception {
            Class<?> minecraftServerClazz = Class.forName("net.minecraft.server." + Util.getRawBukkitVersion() + ".MinecraftServer");
            this.minecraftServerInstance = minecraftServerClazz.getDeclaredMethod("getServer", new Class[0]).invoke(null, new Object[0]);
            this.recentTpsField = minecraftServerClazz.getDeclaredField("recentTps");
            this.recentTpsField.setAccessible(true);
        }

        @Override
        public void tick() {
            if (++TPSTask.this.elapsedTicks % 60 == 0) {
                try {
                    this.tps = ((double[])this.recentTpsField.get(this.minecraftServerInstance))[0];
                }
                catch (IllegalAccessException e) {
                    Util.warning("Clearlag failed to use the internal TPS tracker during runtime. Reverted to estimation... (" + e.getMessage() + ")");
                    TPSTask.this.tpsCalculator = new EstimatedTPSCalculator();
                }
            }
        }

        @Override
        public double calculateCurrentAverageTPS() {
            return this.tps;
        }
    }

    private class EstimatedTPSCalculator
    implements TPSCalculator {
        private long lasTimestamp = -1L;
        private int[] tickLengths = new int[20];
        private double tps = 20.0;

        public EstimatedTPSCalculator() {
            Arrays.fill(this.tickLengths, 50);
        }

        @Override
        public void tick() {
            long currentTime = System.currentTimeMillis();
            if (this.lasTimestamp != -1L) {
                int elaspedTime = (int)(currentTime - this.lasTimestamp);
                if (elaspedTime == 49 || elaspedTime == 51) {
                    elaspedTime = 50;
                }
                this.tickLengths[((TPSTask)TPSTask.this).elapsedTicks % 20] = elaspedTime;
            }
            this.lasTimestamp = currentTime;
            if (++TPSTask.this.elapsedTicks % 20 == 0) {
                double tickSum = 0.0;
                for (int tickLength : this.tickLengths) {
                    tickSum += (double)tickLength;
                }
                double tickLength = tickSum / 20.0;
                this.tps = 50.0 / tickLength * 20.0;
            }
        }

        @Override
        public double calculateCurrentAverageTPS() {
            return this.tps;
        }
    }

    private static interface TPSCalculator {
        public double calculateCurrentAverageTPS();

        public void tick();
    }
}

