/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.modules.TaskModule;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

@ConfigPath(path="lag-spike-helper")
public class LagSpikeTask
extends TaskModule {
    @ConfigValue
    private boolean followStack;
    @ConfigValue
    private int minElapsedTime;
    @AutoWire
    private ConfigHandler configHandler;
    private final Thread mainThread;
    private final AtomicInteger tick = new AtomicInteger();
    private final AtomicLong tickTimestamp = new AtomicLong();
    private final AtomicLong tickGarbageCollectorTimeTotal = new AtomicLong();
    private Timer timer = null;

    public LagSpikeTask() {
        this.mainThread = Thread.currentThread();
    }

    private long getTotalGCCompleteTime() {
        long totalGarbageCollections = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            totalGarbageCollections += gc.getCollectionTime();
        }
        return totalGarbageCollections;
    }

    @Override
    public void run() {
        this.tick.incrementAndGet();
        this.tickTimestamp.set(System.currentTimeMillis());
        this.tickGarbageCollectorTimeTotal.set(this.getTotalGCCompleteTime());
    }

    @Override
    protected int startTask() {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new ThreadWatcherTask(), 50L, this.configHandler.getConfig().getLong("lag-spike-helper.check-interval"));
        return Bukkit.getScheduler().runTaskTimer((Plugin)Clearlag.getInstance(), (Runnable)this, (long)this.getInterval(), (long)this.getInterval()).getTaskId();
    }

    @Override
    public void setDisabled() {
        super.setDisabled();
        Bukkit.getScheduler().cancelTask(this.taskid);
        this.timer.cancel();
        this.timer = null;
    }

    @Override
    public int getInterval() {
        return 1;
    }

    private class ThreadWatcherTask
    extends TimerTask {
        private long lastElaspedTime = 0L;
        private long lastGarbageCollectionTimeTotal = 0L;
        private int frozenTick = -100;
        private String frozenLine = "";
        private boolean frozen = false;

        private ThreadWatcherTask() {
        }

        @Override
        public void run() {
            int currentTick = LagSpikeTask.this.tick.get();
            if (currentTick < 400) {
                return;
            }
            long elapsedTime = System.currentTimeMillis() - LagSpikeTask.this.tickTimestamp.get();
            if (elapsedTime >= (long)LagSpikeTask.this.minElapsedTime) {
                this.frozen = true;
                StackTraceElement[] stackTraceElements = LagSpikeTask.this.mainThread.getStackTrace();
                if (currentTick != this.frozenTick) {
                    this.lastGarbageCollectionTimeTotal = LagSpikeTask.this.tickGarbageCollectorTimeTotal.get();
                    this.frozenTick = currentTick;
                    Util.warning("Clearlag has detected a possible lag spike on tick #" + currentTick + " (Tick is currently at " + elapsedTime + " milliseconds)");
                    Util.warning("Thread name: " + LagSpikeTask.this.mainThread.getName() + " Id: " + LagSpikeTask.this.mainThread.getId());
                    Util.warning("Thread state: " + (Object)((Object)LagSpikeTask.this.mainThread.getState()));
                    Util.warning("Thread stack-trace: ");
                    if (stackTraceElements.length > 0) {
                        for (StackTraceElement ste : stackTraceElements) {
                            System.out.println(" > " + ste);
                        }
                        this.frozenLine = stackTraceElements[0].toString();
                    }
                } else if (LagSpikeTask.this.followStack && stackTraceElements.length > 0 && !stackTraceElements[0].toString().equals(this.frozenLine)) {
                    Util.warning("Thread stack-trace (Stack moved): ");
                    for (StackTraceElement ste : stackTraceElements) {
                        System.out.println(" > " + ste);
                    }
                    this.frozenLine = stackTraceElements[0].toString();
                }
                this.lastElaspedTime = elapsedTime;
            } else if (this.frozen) {
                this.frozenLine = null;
                this.frozen = false;
                Util.warning("Thread '" + LagSpikeTask.this.mainThread.getName() + "' is no longer stuck on tick #" + this.frozenTick);
                Util.warning("Estimated time spent on tick #" + this.frozenTick + ": " + this.lastElaspedTime);
                Util.warning("Garbage collection time during tick: " + (LagSpikeTask.this.getTotalGCCompleteTime() - this.lastGarbageCollectionTimeTotal));
            }
        }
    }
}

