/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.tasks;

import java.lang.reflect.Method;
import java.util.HashMap;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.managers.EntityManager;
import me.minebuilders.clearlag.modules.ClearModule;
import me.minebuilders.clearlag.modules.ClearlagModule;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.Monster;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@ConfigPath(path="halt-command")
public class HaltTask
extends ClearlagModule
implements Listener {
    @ConfigValue
    private boolean removeEntities;
    @ConfigValue
    private boolean disableNaturalEntitySpawning;
    @AutoWire
    private EntityManager entityManager;
    @AutoWire
    private ConfigHandler config;
    private HashMap<World, Integer[]> valuelist;

    @Override
    public void setEnabled() {
        Method[] methods;
        super.setEnabled();
        this.valuelist = new HashMap(Bukkit.getWorlds().size());
        for (World w : Bukkit.getWorlds()) {
            if (this.removeEntities) {
                this.entityManager.removeEntities(new ClearModule(){

                    @Override
                    public boolean isRemovable(Entity e) {
                        return e instanceof Item || e instanceof TNTPrimed || e instanceof ExperienceOrb || e instanceof FallingBlock || e instanceof Monster;
                    }

                    @Override
                    public boolean isWorldEnabled(World w) {
                        return true;
                    }
                });
            }
            if (!this.disableNaturalEntitySpawning) continue;
            Integer[] values = new Integer[6];
            values[0] = w.getAmbientSpawnLimit();
            w.setAmbientSpawnLimit(0);
            values[1] = w.getAnimalSpawnLimit();
            w.setAnimalSpawnLimit(0);
            values[2] = w.getMonsterSpawnLimit();
            w.setMonsterSpawnLimit(0);
            values[3] = (int)w.getTicksPerAnimalSpawns();
            w.setTicksPerAnimalSpawns(0);
            values[4] = (int)w.getTicksPerMonsterSpawns();
            w.setTicksPerMonsterSpawns(0);
            values[5] = w.getWaterAnimalSpawnLimit();
            w.setWaterAnimalSpawnLimit(0);
            this.valuelist.put(w, values);
        }
        PluginManager pm = Clearlag.getInstance().getServer().getPluginManager();
        for (final Method method : methods = this.getClass().getDeclaredMethods()) {
            Class<?>[] params;
            EventHandler he = method.getAnnotation(EventHandler.class);
            if (he == null || !this.config.getConfig().getBoolean("halt-command.halted." + this.config.javaToConfigValue(method.getName())) || !Event.class.isAssignableFrom((params = method.getParameterTypes())[0]) || params.length != 1) continue;
            final Class<Event> eventClass = params[0].asSubclass(Event.class);
            method.setAccessible(true);
            EventExecutor executor = new EventExecutor(){

                public void execute(Listener listener, Event event) throws EventException {
                    try {
                        if (!eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        method.invoke((Object)listener, event);
                    }
                    catch (Exception ex) {
                        throw new EventException(ex.getCause());
                    }
                }
            };
            pm.registerEvent(eventClass, (Listener)this, he.priority(), executor, (Plugin)Clearlag.getInstance(), he.ignoreCancelled());
        }
    }

    @Override
    public void setDisabled() {
        super.setDisabled();
        if (!this.valuelist.isEmpty()) {
            for (World w : this.valuelist.keySet()) {
                Integer[] values = this.valuelist.get(w);
                w.setAmbientSpawnLimit(values[0].intValue());
                w.setAnimalSpawnLimit(values[1].intValue());
                w.setMonsterSpawnLimit(values[2].intValue());
                w.setTicksPerAnimalSpawns(values[3].intValue());
                w.setTicksPerMonsterSpawns(values[4].intValue());
                w.setWaterAnimalSpawnLimit(values[5].intValue());
            }
        }
        this.valuelist = null;
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void fire(BlockIgniteEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void fireBurn(BlockBurnEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void explosion(EntityExplodeEvent e) {
        e.setCancelled(true);
        e.blockList().clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void decay(LeavesDecayEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockForm(BlockFormEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockSpread(BlockSpreadEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockFade(BlockFadeEvent e) {
        e.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void blockNaturalChange(BlockFromToEvent e) {
        e.setCancelled(true);
    }
}

