/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.statrenderers;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.minebuilders.clearlag.RAMUtil;
import me.minebuilders.clearlag.adapters.VersionAdapter;
import me.minebuilders.clearlag.statrenderers.StatRenderer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapView;
import org.bukkit.map.MinecraftFont;

public class MemoryRenderer
extends StatRenderer {
    private final byte[] memoryPalettes = new byte[]{16, 4, 28, 8, 40};
    private final LinkedList<MemorySampleColumn> memorySamples = new LinkedList();
    private final List<MemoryPoolMXBean> memoryBeans = new ArrayList<MemoryPoolMXBean>();
    private final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private long gcLastPauseTime = this.getTotalGCCompleteTime();

    public MemoryRenderer(Player observer, int sampleTicks, ItemStack mapItemStack, VersionAdapter versionAdapter, MapView mapView) {
        super(observer, sampleTicks, mapItemStack, versionAdapter, mapView);
        for (MemoryPoolMXBean memoryBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryBean.getType() != MemoryType.HEAP) continue;
            this.memoryBeans.add(memoryBean);
        }
        String[] colorTypes = new String[]{"Dark Red", "Light Green", "Dark Green", "Light Brown", "Brown"};
        int colorIndex = 0;
        for (int i = this.memoryBeans.size() - 1; i >= 0; --i) {
            MemoryPoolMXBean memoryBean = this.memoryBeans.get(i);
            int color = colorIndex >= colorTypes.length ? (colorIndex = 0) : colorIndex++;
            observer.sendMessage(ChatColor.RED + " - " + ChatColor.DARK_GREEN + memoryBean.getName() + ChatColor.DARK_GRAY + ": " + ChatColor.GREEN + colorTypes[color]);
        }
    }

    private long getTotalGCCompleteTime() {
        long totalGarbageCollections = 0L;
        for (GarbageCollectorMXBean gc : this.gcBeans) {
            long count = gc.getCollectionTime();
            if (count < 0L) continue;
            totalGarbageCollections += count;
        }
        return totalGarbageCollections;
    }

    @Override
    public void tick() {
        MemorySampleColumn column = new MemorySampleColumn();
        for (MemoryPoolMXBean memoryBean : this.memoryBeans) {
            column.addMemorySample(new MemorySample(RAMUtil.toMB(memoryBean.getUsage().getUsed())));
        }
        long totalGCTime = this.getTotalGCCompleteTime();
        long gcTime = totalGCTime - this.gcLastPauseTime;
        if (gcTime > 0L) {
            column.garbageCollectionTime = (int)gcTime;
        }
        this.gcLastPauseTime = totalGCTime;
        this.memorySamples.addLast(column);
        while (this.memorySamples.size() > this.width) {
            this.memorySamples.removeFirst();
        }
    }

    @Override
    public void draw(MapView mapView, MapCanvas mapCanvas, Player player) {
        int maxHeapSize = RAMUtil.toMB(Runtime.getRuntime().totalMemory());
        int x = 0;
        for (MemorySampleColumn memorySampleColumn : this.memorySamples) {
            int colorIndex = 0;
            int baseY = 0;
            int drawTo = this.height;
            for (int i = memorySampleColumn.memorySamples.size() - 1; i >= 0; --i) {
                MemorySample sample = (MemorySample)memorySampleColumn.memorySamples.get(i);
                byte color = this.memoryPalettes[colorIndex >= this.memoryPalettes.length ? (colorIndex = 0) : colorIndex++];
                int y = (sample.usageInMB + baseY) * this.height / maxHeapSize;
                for (int j = this.height - y; j < drawTo; ++j) {
                    mapCanvas.setPixel(x, j, color);
                }
                baseY = sample.usageInMB + baseY;
                drawTo = this.height - y;
            }
            ++x;
        }
        x = 0;
        for (MemorySampleColumn memorySampleColumn : this.memorySamples) {
            if (memorySampleColumn.didGarbageCollection()) {
                mapCanvas.drawText(x, this.height - 8, (MapFont)MinecraftFont.Font, "\u00a732;" + memorySampleColumn.garbageCollectionTime + "ms");
            }
            ++x;
        }
        for (Object yPos : (Object)new double[]{0.0, 0.25, 0.5, 0.75}) {
            int y = (int)((double)maxHeapSize * yPos * (double)this.height / (double)maxHeapSize);
            mapCanvas.drawText(5, y, (MapFont)MinecraftFont.Font, "\u00a748;" + (double)Math.round((double)maxHeapSize * (1.0 - yPos) / 1000.0 * 10.0) / 10.0 + "GB");
            for (int i = 0; i < 5; ++i) {
                mapCanvas.setPixel(i, y, (byte)20);
            }
        }
        double time = (double)Math.round((double)(this.width * this.sampleTicks) / 20.0 * 10.0) / 10.0;
        mapCanvas.drawText(35, 0, (MapFont)MinecraftFont.Font, time + " second sample");
    }

    private static class MemorySample {
        private int usageInMB;

        public MemorySample(int usageInMB) {
            this.usageInMB = usageInMB;
        }
    }

    private static class MemorySampleColumn {
        private List<MemorySample> memorySamples = new ArrayList<MemorySample>(5);
        private int garbageCollectionTime = -1;

        private MemorySampleColumn() {
        }

        public void addMemorySample(MemorySample memorySample) {
            this.memorySamples.add(memorySample);
        }

        public boolean didGarbageCollection() {
            return this.garbageCollectionTime > 0;
        }
    }
}

