/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.modules;

import java.util.Arrays;
import me.minebuilders.clearlag.CommandListener;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.exceptions.WrongCommandArgumentException;
import me.minebuilders.clearlag.language.LanguageManager;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.modules.ClearlagModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class CommandModule
extends ClearlagModule {
    @LanguageValue(key="command.error.wrongUsage")
    protected Message wrongUsage;
    @LanguageValue(key="command.error.noPermission")
    private Message noPermission;
    @LanguageValue(key="command.error.onlyForPlayers")
    private Message onlyForPlayers;
    @AutoWire
    private LanguageManager languageManager;
    @AutoWire
    private CommandListener commandListener;
    protected String displayName;
    protected String name = this.getClass().getSimpleName().replace("Cmd", "").toLowerCase();
    protected int argLength = 0;
    protected String usage = "";
    protected String desc = "";

    public void processCmd(CommandSender sender, String[] arg) throws WrongCommandArgumentException {
        if (!sender.hasPermission("lagg." + this.name)) {
            throw new WrongCommandArgumentException(this.noPermission, this.displayName);
        }
        if (this.argLength >= arg.length) {
            throw new WrongCommandArgumentException(this.wrongUsage, this.usage, this.displayName);
        }
        if (arg.length >= 1) {
            arg = Arrays.copyOfRange(arg, 1, arg.length);
        }
        if (sender instanceof Player) {
            this.run((Player)sender, arg);
        } else {
            this.run(sender, arg);
        }
    }

    protected void run(Player player, String[] args) throws WrongCommandArgumentException {
        this.run((CommandSender)player, args);
    }

    protected void run(CommandSender sender, String[] args) throws WrongCommandArgumentException {
        throw new WrongCommandArgumentException(this.onlyForPlayers, new Object[0]);
    }

    @Override
    public void setEnabled() {
        super.setEnabled();
        if (this.getClass().getPackage().getName().startsWith("me.minebuilders.clearlag.")) {
            this.displayName = this.languageManager.getMessage("command." + this.name + ".name").getRawStringMessage();
            this.desc = this.languageManager.getMessage("command." + this.name + ".desc").getRawStringMessage();
            this.usage = this.languageManager.getMessage("command." + this.name + ".usage").getRawStringMessage();
        } else {
            this.displayName = this.name;
        }
        this.commandListener.addCmd(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getArgLength() {
        return this.argLength;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getDescription() {
        return this.desc;
    }
}

