/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.modules;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.modules.ClearlagModule;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

@ConfigPath(path="global-broadcasts")
public class BroadcastHandler
extends ClearlagModule {
    @ConfigValue
    private boolean usePermissionForBroadcasts;
    @ConfigValue
    private String permission;
    @ConfigValue
    private boolean async;
    private Broadcaster broadcaster = new DefaultBroadcaster();

    public void broadcast(String message) {
        this.broadcast(new String[]{message});
    }

    public void broadcast(String[] message) {
        if (this.isEnabled()) {
            for (int i = 0; i < message.length; ++i) {
                message[i] = Util.color(message[i]);
            }
            if (this.async && !(this.broadcaster instanceof AsyncBroadcaster)) {
                this.broadcaster = new AsyncBroadcaster(this.broadcaster);
            }
            this.broadcaster.broadcast(message);
        }
    }

    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    private static class AsyncBroadcaster
    implements Broadcaster {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private final Broadcaster wrappedBroadcaster;

        public AsyncBroadcaster(Broadcaster wrappedBroadcaster) {
            this.wrappedBroadcaster = wrappedBroadcaster;
        }

        @Override
        public void broadcast(String[] message) {
            this.executor.submit(() -> this.wrappedBroadcaster.broadcast(message));
        }
    }

    private class DefaultBroadcaster
    implements Broadcaster {
        private DefaultBroadcaster() {
        }

        @Override
        public void broadcast(String[] message) {
            if (BroadcastHandler.this.usePermissionForBroadcasts) {
                for (String str : message) {
                    Bukkit.broadcast((String)str, (String)BroadcastHandler.this.permission);
                }
            } else {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    for (String str : message) {
                        p.sendMessage(str);
                    }
                }
            }
        }
    }

    public static interface Broadcaster {
        public void broadcast(String[] var1);
    }
}

