/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Chunk;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

@ConfigPath(path="mobspawner")
public class MobSpawerListener
extends EventModule {
    @ConfigValue
    private int maxSpawn;
    @ConfigValue
    private boolean removeMobsOnChunkUnload;
    private HashMap<ChunkKey, List<Entity>> map = new HashMap();

    private boolean isOverLimit(List<Entity> en) {
        Iterator<Entity> ee = en.iterator();
        int amount = 0;
        while (ee.hasNext()) {
            if (ee.next().isDead()) {
                ee.remove();
                continue;
            }
            ++amount;
        }
        return amount >= this.maxSpawn;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        LivingEntity e = event.getEntity();
        if (event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.SPAWNER) {
            ChunkKey key = new ChunkKey(event.getLocation().getChunk());
            List<Entity> entities = this.map.get(key);
            if (entities == null) {
                entities = new ArrayList<Entity>();
                this.map.put(key, entities);
            }
            if (this.removeMobsOnChunkUnload) {
                e.setRemoveWhenFarAway(true);
            }
            if (!this.isOverLimit(entities)) {
                entities.add((Entity)e);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=false)
    public void onChunkUnload(ChunkUnloadEvent event) {
        this.map.remove(new ChunkKey(event.getChunk()));
    }

    private class ChunkKey {
        private int x;
        private int z;
        private UUID worldUuid;

        ChunkKey(Chunk c) {
            this.x = c.getX();
            this.z = c.getZ();
            this.worldUuid = c.getWorld().getUID();
        }

        public int hashCode() {
            return this.x * 33 + this.z * 67 + this.worldUuid.hashCode() / 4;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            ChunkKey ck = (ChunkKey)obj;
            return ck.x == this.x && ck.z == this.z && ck.worldUuid == this.worldUuid;
        }
    }
}

