/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.minebuilders.clearlag.ChunkKey;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.block.Hopper;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.plugin.Plugin;

@ConfigPath(path="hopper-limiter")
public class HopperLimitListener
extends EventModule
implements Runnable {
    @ConfigValue
    private int transferLimit = 6;
    @ConfigValue
    private int checkInterval = 1;
    private int schedulerID = -1;
    private Map<ChunkKey, Integer> hopperDataMap = new HashMap<ChunkKey, Integer>();

    @EventHandler
    public void onHopper(InventoryMoveItemEvent event) {
        if (event.getSource().getHolder() instanceof Hopper) {
            ChunkKey chunkKey = new ChunkKey(((Hopper)event.getSource().getHolder()).getChunk());
            Integer transfers = this.hopperDataMap.get(chunkKey);
            if (transfers == null) {
                transfers = 0;
            }
            if (transfers >= this.transferLimit) {
                event.setCancelled(true);
            } else {
                transfers = transfers + 1;
            }
            this.hopperDataMap.put(chunkKey, transfers);
        }
    }

    @Override
    public void run() {
        Iterator<Map.Entry<ChunkKey, Integer>> entries = this.hopperDataMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<ChunkKey, Integer> entry = entries.next();
            if (entry.getValue() == 0) {
                entries.remove();
                continue;
            }
            entry.setValue(0);
        }
    }

    @Override
    public void setEnabled() {
        super.setEnabled();
        this.schedulerID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Clearlag.getInstance(), (Runnable)this, (long)this.checkInterval * 20L, (long)this.checkInterval * 20L);
    }

    @Override
    public void setDisabled() {
        super.setDisabled();
        if (this.schedulerID != -1) {
            Bukkit.getServer().getScheduler().cancelTask(this.schedulerID);
            this.hopperDataMap = new HashMap<ChunkKey, Integer>();
        }
    }
}

