/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.Map;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.modules.EventModule;
import me.minebuilders.clearlag.reflection.ReflectionUtil;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;

@ConfigPath(path="mob-range")
public class EntityAISpawnListener
extends EventModule {
    private Map<EntityType, Double> mobRanges = new IdentityHashMap<EntityType, Double>();
    private Method getHandleMethod;
    private Method getAttriInstanceMethod;
    private Method setAttriMethod;
    private Object followRangeConst;
    @AutoWire
    private ConfigHandler configHandler;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) throws Exception {
        this.setEntityRange((Entity)event.getEntity());
    }

    @Override
    public void setEnabled() {
        try {
            String version = Util.getRawBukkitVersion();
            Class<?> craftEntity = Class.forName("org.bukkit.craftbukkit." + version + ".entity.CraftEntity");
            Class<?> nmsEntity = Class.forName("net.minecraft.server." + version + ".EntityLiving");
            Class<?> genAttributes = Class.forName("net.minecraft.server." + version + ".GenericAttributes");
            Class<?> attribClass = Class.forName("net.minecraft.server." + version + ".AttributeInstance");
            Field followRangeField = genAttributes.getDeclaredField(version.contains("1_7") ? "b" : "FOLLOW_RANGE");
            followRangeField.setAccessible(true);
            this.followRangeConst = followRangeField.get(null);
            this.setAttriMethod = ReflectionUtil.getMethodByName(attribClass, "setValue");
            this.setAttriMethod.setAccessible(true);
            this.getHandleMethod = craftEntity.getDeclaredMethod("getHandle", new Class[0]);
            this.getHandleMethod.setAccessible(true);
            this.getAttriInstanceMethod = ReflectionUtil.getMethodByName(nmsEntity, "getAttributeInstance");
            this.getAttriInstanceMethod.setAccessible(true);
            for (World w : Bukkit.getWorlds()) {
                for (Entity e : w.getEntities()) {
                    if (!(e instanceof LivingEntity)) continue;
                    this.setEntityRange(e);
                }
            }
            super.setEnabled();
        }
        catch (Exception e) {
            Util.warning("Failed to initialize 'mob-range' controller ~ This is possibly caused by an unsupported Bukkit/Spigot server version");
            return;
        }
        Configuration config = this.configHandler.getConfig();
        for (String s : config.getConfigurationSection("mob-range").getKeys(false)) {
            EntityType type = Util.getEntityTypeFromString(s);
            if (type == null) continue;
            this.mobRanges.put(type, config.getDouble("mob-range." + s));
        }
    }

    private void setEntityRange(Entity e) throws Exception {
        Double value = this.mobRanges.get(e.getType());
        if (value != null) {
            this.setAttriMethod.invoke(this.getAttriInstanceMethod.invoke(this.getHandleMethod.invoke((Object)e, new Object[0]), this.followRangeConst), value);
        }
    }
}

