/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import java.util.List;
import me.minebuilders.clearlag.Clearlag;
import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.config.ConfigValueType;
import me.minebuilders.clearlag.entities.EntityMap;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

@ConfigPath(path="per-entity-chunk-entity-limiter")
public class ChunkPerEntityLimiterListener
extends EventModule {
    @ConfigValue(valueType=ConfigValueType.ENTITY_LIMIT_MAP)
    private EntityMap<Integer> entityLimits;
    private BukkitTask passivePurger = null;

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkLoad(ChunkLoadEvent event) {
        this.purgeEntities(event.getChunk().getEntities());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSpawn(CreatureSpawnEvent event) {
        Entity[] entities;
        LivingEntity entity = event.getEntity();
        Integer limit = this.entityLimits.getValue((Entity)entity);
        if (limit != null && (entities = event.getLocation().getChunk().getEntities()).length >= limit) {
            int count = 0;
            for (Entity e : entities) {
                if (entity.getType() != e.getType() || !this.entityLimits.getValue(e).equals(limit)) continue;
                ++count;
            }
            event.setCancelled(count >= limit);
        }
    }

    private void purgeEntities(Entity[] entities) {
        if (entities.length > 0) {
            EntityMap<Integer> entityMap = new EntityMap<Integer>();
            for (Entity entity : entities) {
                Integer limit = this.entityLimits.getValue(entity);
                if (limit == null) continue;
                Integer amount = (Integer)entityMap.getValue(entity);
                amount = amount == null ? Integer.valueOf(1) : Integer.valueOf(amount + 1);
                entityMap.set(entity.getType(), amount);
                if (amount <= limit) continue;
                entity.remove();
            }
        }
    }

    @Override
    public void setEnabled() {
        super.setEnabled();
        if (Clearlag.getInstance().getConfig().getBoolean("per-entity-chunk-entity-limiter.passive-cleaner.passive-cleaning-enabled")) {
            this.passivePurger = new PassivePurger(Clearlag.getInstance().getConfig().getInt("per-entity-chunk-entity-limiter.passive-cleaner.chunk-batch-size")).runTaskTimer((Plugin)Clearlag.getInstance(), Clearlag.getInstance().getConfig().getInt("per-entity-chunk-entity-limiter.passive-cleaner.check-interval"), Clearlag.getInstance().getConfig().getInt("per-entity-chunk-entity-limiter.passive-cleaner.check-interval"));
        }
    }

    @Override
    public void setDisabled() {
        super.setDisabled();
        if (this.passivePurger != null) {
            this.passivePurger.cancel();
            this.passivePurger = null;
        }
    }

    private class PassivePurger
    extends BukkitRunnable {
        private final int chunkBatchSize;
        private int worldIndex = 0;
        private int chunkIndex = 0;

        private PassivePurger(int chunkBatchSize) {
            this.chunkBatchSize = chunkBatchSize;
        }

        public void run() {
            List worlds = Bukkit.getWorlds();
            if (worlds.isEmpty()) {
                return;
            }
            if (this.worldIndex >= worlds.size()) {
                this.worldIndex = 0;
            }
            int processedChunks = 0;
            World world = (World)worlds.get(this.worldIndex);
            while (processedChunks < this.chunkBatchSize) {
                Chunk[] chunks = world.getLoadedChunks();
                if (chunks.length > this.chunkIndex) {
                    while (this.chunkIndex < chunks.length && processedChunks < this.chunkBatchSize) {
                        ChunkPerEntityLimiterListener.this.purgeEntities(chunks[this.chunkIndex].getEntities());
                        ++processedChunks;
                        ++this.chunkIndex;
                    }
                }
                if (processedChunks >= this.chunkBatchSize) continue;
                if (++this.worldIndex >= worlds.size()) {
                    this.worldIndex = 0;
                    return;
                }
                this.chunkIndex = 0;
            }
        }
    }
}

