/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.listeners;

import me.minebuilders.clearlag.annotations.ConfigPath;
import me.minebuilders.clearlag.annotations.ConfigValue;
import me.minebuilders.clearlag.modules.EventModule;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerMoveEvent;

@ConfigPath(path="player-speed-limiter")
public class ChunkOverloadListener
extends EventModule {
    @ConfigValue
    private double moveMaxSpeed;
    @ConfigValue
    private double flyMaxSpeed;

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onMove(PlayerMoveEvent event) {
        if (!event.getPlayer().isInsideVehicle()) {
            Location to = event.getTo();
            Location from = event.getFrom();
            if (to.getBlockX() != from.getBlockX() || to.getBlockZ() != from.getBlockZ()) {
                double distance = Math.hypot(from.getX() - to.getX(), from.getZ() - to.getZ());
                double d = event.getPlayer().isFlying() ? this.flyMaxSpeed : this.moveMaxSpeed;
                if (distance > d) {
                    event.setTo(from);
                }
            }
        }
    }
}

