/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.language.messages;

import java.util.HashMap;
import java.util.Map;
import me.minebuilders.clearlag.language.messages.BasicMessage;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.modules.BroadcastHandler;
import org.bukkit.command.CommandSender;

public class MessageTree
implements Message {
    private Map<String, Message> messageList = new HashMap<String, Message>(5);
    private int currentReadIndex = 0;

    public void addMessage(String key, Message message) {
        this.messageList.put(key, message);
    }

    public void removeMessage(String key) {
        this.messageList.remove(key);
    }

    @Override
    public String getRawStringMessage() {
        return "N/A";
    }

    public Message getMessage(String key) {
        Message message = this.messageList.get(key);
        if (message == null) {
            return new BasicMessage(new BroadcastHandler(), "Your language file is missing an entry for key '" + key + "'!", new String[0]);
        }
        return message;
    }

    private Message getNextMessage() {
        Message message = this.messageList.get(this.currentReadIndex++);
        if (this.messageList.size() >= this.currentReadIndex) {
            this.resetReadIndex();
        }
        return message;
    }

    @Override
    public String getStringMessage(Object ... obj) {
        return this.getNextMessage().getStringMessage(obj);
    }

    @Override
    public void sendMessage(CommandSender sender, Object ... obj) {
        this.getNextMessage().sendMessage(sender, obj);
    }

    public void sendMessage(String key, CommandSender sender, Object ... obj) {
        this.getMessage(key).sendMessage(sender, obj);
    }

    public void broadcastMessage(String key, Object ... obj) {
        this.getMessage(key).broadcastMessage(obj);
    }

    @Override
    public void broadcastMessage(Object ... obj) {
        this.getNextMessage().broadcastMessage(obj);
    }

    public void resetReadIndex() {
        this.currentReadIndex = 0;
    }
}

