/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.language;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.language.LanguageValue;
import me.minebuilders.clearlag.language.messages.BasicMessage;
import me.minebuilders.clearlag.language.messages.Message;
import me.minebuilders.clearlag.language.messages.MessageBlock;
import me.minebuilders.clearlag.language.messages.MessageTree;
import me.minebuilders.clearlag.modules.BroadcastHandler;
import me.minebuilders.clearlag.modules.Module;
import org.bukkit.ChatColor;

public class LanguageLoader {
    private Map<String, Message> fallbackLanguageMap = null;
    private Map<String, Message> languageMap = null;
    private BroadcastHandler broadcastHandler;

    public LanguageLoader(BroadcastHandler broadcastHandler) {
        this.broadcastHandler = broadcastHandler;
    }

    public void wireInMessages(Object object) throws Exception {
        for (Class<?> clazz = object.getClass(); clazz != null && clazz != Object.class && clazz != Module.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(LanguageValue.class)) continue;
                field.setAccessible(true);
                Message message = this.getMessageByKey(field.getAnnotation(LanguageValue.class).key());
                if (message == null) {
                    message = new BasicMessage(this.broadcastHandler, ChatColor.RED + "!Missing-From-Language-File!", new String[0]);
                }
                field.set(object, message);
            }
        }
    }

    public Message getMessageByKey(String key) {
        Message message = this.languageMap.get(key);
        if (message == null) {
            message = this.fallbackLanguageMap != null ? this.fallbackLanguageMap.get(key) : new BasicMessage(this.broadcastHandler, ChatColor.RED + "!Missing-From-Language-File!", new String[0]);
        }
        return message;
    }

    public void setLanguageMap(InputStream input) throws Exception {
        this.languageMap = this.loadLanguage(input);
    }

    public void setFallbackLanguageMap(InputStream input) throws Exception {
        this.fallbackLanguageMap = this.loadLanguage(input);
    }

    private Map<String, Message> loadLanguage(InputStream in) throws Exception {
        String line;
        HashMap<String, Message> loadedMessageMap = new HashMap<String, Message>();
        HashMap<String, MessageTree> loadedMessageTrees = new HashMap<String, MessageTree>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            Message insertingMessage;
            String message;
            if (line.startsWith("#") || line.trim().isEmpty()) continue;
            String[] lineParts = line.split("=", 2);
            String[] keyBits = lineParts[0].split("\\(", 2);
            String[] replaceValues = lineParts[0].substring(lineParts[0].indexOf("(") + 1, lineParts[0].indexOf(")")).split(",");
            if (replaceValues.length == 1 && replaceValues[0].isEmpty()) {
                replaceValues = new String[]{};
            }
            if ((message = Util.color(lineParts[1])).trim().equals("{")) {
                LinkedList<String> currentMessageBlock = new LinkedList<String>();
                while ((line = reader.readLine()) != null && !line.trim().equals("}")) {
                    currentMessageBlock.add(Util.color(line));
                }
                insertingMessage = new MessageBlock(this.broadcastHandler, currentMessageBlock.toArray(new String[0]), replaceValues);
            } else {
                insertingMessage = new BasicMessage(this.broadcastHandler, message, replaceValues);
            }
            int treeEndLength = keyBits[0].lastIndexOf(".") + 1;
            String treeKey = keyBits[0].substring(0, treeEndLength);
            String treeMessageKey = keyBits[0].substring(treeEndLength);
            MessageTree tree = (MessageTree)loadedMessageTrees.get(treeKey);
            if (tree == null) {
                tree = new MessageTree();
                loadedMessageTrees.put(treeKey, tree);
                loadedMessageMap.put(treeKey, tree);
            }
            tree.addMessage(treeMessageKey, insertingMessage);
            loadedMessageMap.put(keyBits[0], insertingMessage);
        }
        return loadedMessageMap;
    }
}

