/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.minebuilders.clearlag.entities.attributes.EntityAttribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class EntityMap<T> {
    private final Node<T>[] entityTable = new Node[EntityType.values().length + 1];

    public boolean containsEntity(Entity entity) {
        Node<T> node = this.entityTable[entity.getType().ordinal()];
        if (node != null) {
            for (EntityAttribute e : ((Node)node).attributes) {
                if (e.containsData(entity)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public T getValue(Entity entity) {
        Node<T> node = this.entityTable[entity.getType().ordinal()];
        if (node != null) {
            for (EntityAttribute e : ((Node)node).attributes) {
                if (e.containsData(entity)) continue;
                return null;
            }
            return (T)((Node)node).value;
        }
        return null;
    }

    public void set(EntityType type, ArrayList<EntityAttribute<Entity>> entityAttributes, T value) {
        this.entityTable[type.ordinal()] = new Node(entityAttributes, value);
    }

    public void set(EntityType type, T value) {
        this.entityTable[type.ordinal()] = new Node(Collections.emptyList(), value);
    }

    private static class Node<T> {
        private List<EntityAttribute<Entity>> attributes;
        private T value;

        private Node(List<EntityAttribute<Entity>> attributes, T value) {
            this.attributes = attributes;
            this.value = value;
        }
    }
}

