/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config.configvalues;

import java.util.HashMap;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.config.configvalues.ConfigData;

public class WarnMapCV
implements ConfigData<HashMap<Integer, String[]>> {
    @AutoWire
    private ConfigHandler configHandler;

    @Override
    public HashMap<Integer, String[]> getValue(String path) {
        HashMap<Integer, String[]> warns = new HashMap<Integer, String[]>();
        for (String line : this.configHandler.getConfig().getStringList(path)) {
            try {
                String[] bits = line.split(" ", 2);
                int time = Integer.parseInt(bits[0].replace("time:", ""));
                String[] msg = Util.color(bits[1].replace("msg:", "")).split("/n");
                if (time > 0) {
                    warns.put(time, msg);
                    continue;
                }
                Util.warning("Config Error at line " + path + ":");
                Util.warning(line + " is an invalid warning!");
            }
            catch (Exception e) {
                Util.warning("Config Read Error at line " + path + ":");
                if (!(e instanceof NumberFormatException)) continue;
                Util.warning("Failed to read 'time:' variable in " + line);
                Util.warning("Insure you have a NUMBER after 'time:' specified");
            }
        }
        return warns;
    }
}

