/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config.configvalues;

import java.util.List;
import java.util.StringTokenizer;
import me.minebuilders.clearlag.Util;
import me.minebuilders.clearlag.annotations.AutoWire;
import me.minebuilders.clearlag.config.ConfigHandler;
import me.minebuilders.clearlag.config.configvalues.ConfigData;
import me.minebuilders.clearlag.entities.AttributeParser;
import me.minebuilders.clearlag.entities.EntityTable;
import org.bukkit.entity.EntityType;

public class EntityTypeTable
implements ConfigData<EntityTable> {
    @AutoWire
    private ConfigHandler configHandler;

    @Override
    public EntityTable getValue(String path) {
        List entities = this.configHandler.getConfig().getStringList(path);
        EntityTable table = new EntityTable();
        AttributeParser attributeParser = new AttributeParser();
        for (String entityLine : entities) {
            try {
                StringTokenizer tokenizer = new StringTokenizer(entityLine);
                String entityName = tokenizer.nextToken();
                EntityType entityType = Util.getEntityTypeFromString(entityName);
                if (entityType != null) {
                    try {
                        AttributeParser.Result result = attributeParser.getAttributesFromString(entityType, tokenizer);
                        for (String nonApplicable : result.getNonApplicables()) {
                            Util.warning("Invalid entity attribute path=\"" + path + "\" token=" + nonApplicable + "\"");
                        }
                        if (result.getAttributes().isEmpty()) {
                            table.setEntity(entityType);
                            continue;
                        }
                        table.setEntityAttributes(entityType, result.getAttributes());
                    }
                    catch (Exception e) {
                        Util.warning("Failed to read entity path=\"" + path + "\" type=" + entityType.name() + "\" error=\"" + e + "\"");
                        e.printStackTrace();
                    }
                    continue;
                }
                Util.warning("Invalid entity type specified path=\"" + path + "\" value=" + entityName);
            }
            catch (Exception e) {
                Util.warning("Invalid line specified path=\"" + path + "\" line=" + entityLine);
            }
        }
        return table;
    }
}

