/*
 * Decompiled with CFR 0.152.
 */
package me.minebuilders.clearlag.config.configupdater.entries;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.minebuilders.clearlag.config.configupdater.entries.ConfigEntry;

public class TreeConfigEntry
implements ConfigEntry {
    private String key;
    private List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public TreeConfigEntry(String key) {
        this.key = key;
    }

    public void addConfigEntry(ConfigEntry entry) {
        this.entries.add(entry);
    }

    public void removeConfigEntry(ConfigEntry entry) {
        this.entries.remove(entry);
    }

    @Override
    public void merge(ConfigEntry mergingEntry) {
        if (mergingEntry instanceof TreeConfigEntry) {
            this.merge((TreeConfigEntry)mergingEntry);
        }
    }

    public void merge(TreeConfigEntry mergingTree) {
        for (ConfigEntry entry : this.entries) {
            for (ConfigEntry mergingEntry : mergingTree.entries) {
                if (!entry.getKey().equals(mergingEntry.getKey())) continue;
                entry.merge(mergingEntry);
            }
        }
    }

    @Override
    public Object getValue() {
        return this.entries;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void write(BufferedWriter writer, int tabs) throws IOException {
        for (int i = 0; i < tabs; ++i) {
            writer.write("  ");
        }
        writer.write(this.key + ":");
        writer.newLine();
        for (ConfigEntry entry : this.entries) {
            entry.write(writer, tabs + 1);
        }
    }
}

